# Ajax Chat 4.0 #

## installation ##

All commands here are called from the main Application Path. 

### Dependencies ###

Place the folder into a Webspace of you choice. An Apache or Nginx Webserver with PHP > 7.2 is recommend. 

On Ubuntu Systems install all dependencies:

	sudo apt install php sqlite3 php-sqlite3


### Setup the Application ###

Clone or extract all Files int a Folder which is available for a webserver (nginx, apache, etc.) and 

Open a Browser and direct to your Webserver. All Databases will create into a subfolder named `db`. So you have to create them and make shure the permissions are also correct. 

Something like this should apear:

	Folder for Database does not exists!

	Please run the following commands:
	sudo mkdir /home/user/Sites/chat/db
	sudo chown -R www-data /home/user/Sites/chat/db

All Tables in the Database should be created automaticly. So if you Delete the Database or on of the Tables, the Application will create the right Schema and insert some default Data into it on the first Page call.


## Ideas ##

- Chat should be scrollable
- Clear Chat possibility
- Import/Export for all data
- Mark signed users
- mention other users
- Private Chats
- Statusbar to view System State (CPU temp, load, user amount (ndsctl clients), temp, humidity, pressure (on the Pi connected BMP Sensor).
)
- File Up & Download and pssibility to link them in chats
- More Clientinfos (OS, Sharing, open Ports)


## Commands ##

Kick user from Captive Portal:

	ndsctl deauth Ma:cA:dr:es:se
	
	ndsctl -h

    status              View the status of nodogsplash
    clients             Display machine-readable client list
    json [mac|ip|token] Display client list in json format
    stop                Stop the running nodogsplash
    auth mac|ip|token   Authenticate user with specified mac, ip or token
    deauth mac|ip|token Deauthenticate user with specified mac, ip or token
    block mac           Block the given MAC address
    unblock mac         Unblock the given MAC address
    allow mac           Allow the given MAC address
    unallow mac         Unallow the given MAC address
    trust mac           Trust the given MAC address
    untrust mac         Untrust the given MAC address
    debuglevel n        Set debug level to n


Commands for Wifi deauth:

    aireplay-ng --deauth 11 -c Ma:cA:dr:es:se -a Ma:cA:dr:es:se wlan0

    11 = 11 versuche (sicher ist sicher)
    -c = client
    -a = accesspoint


OS Detection:

	nmap -O ip-adresse


Request Client Shares:

	smbclient -L ip-adresse



## Changelog ##

### 2.2 ###

- API Request must be authorized by a user or Page token
- Fix initial non scroll bug


### 2.1 ###

- Search in Chats (need a better formating but works)
- Fix small Bugs and Make better smartphone Chatview


### 2.0 ###

- Cleanup Bootstrap Layout
- Cleanup Navigation
- Add clickable html links replacement into chatmessages
- Replace javascript ajax calls by jQuery Ajax calls
- Cleanup javascript
- Add Bootstrap glyphicons
- Fix Navigationbugs


### 1.5 ###

- User online status in Chats
- Bootstrap Useroverview, Login and Register



### 1.4 ###

- Add Bootstrap CSS & JS
- Add JS TImer
- Create Base Bootstrap Layout


### 1.3 ###

- Add Chats Overview, Create, Read, Update, Delete
- Add Chat Overview, Create, Read


### 1.2 ###

- Add Registration
- Add Login


### 1.1 ###

- Add Users Overview, Create, Read, Update, Delete
- Add Session Enviroment


### 1.0 ###

- initial commit (chat by plain text file and less php)



## ToDo ##

- System page, skript pathes
- Token Page, ech user should controll his own token data
- In Users.php -> parse show request and run scripts to detect data
- Notification (change favicon? ring bell (if allowed)? default page notifications like netflix?)
- Notification when user is mentioned and window is out of focus
- The Debug modus (need setup db for persistence)
- System State Data (Base.php?)
  - CPU temp, load, processes, diskspace etc
  - user amount (ndsctl clients)
  - temp, humidity, pressure fromon the Pi connected BMP Sensor
- In all classes change the DB Type to config.php


## Bugs ##

- no known bugs. Feel free to report one.


## Links ##

- The [Bootstrap Doku][] Page
- A nice CSS designed [chat Template][]
- Coding by [mvattersen][]


[Bootstrap Doku]: https://getbootstrap.com/docs/3.3/components/
[chat Template]: https://codepen.io/argyleink/pen/RwPWqKe
[mvattersen]: http://www.mvattersen.de/


## Remote ##

Currently you can post a new Entry by sending a request:

	curl -X POST 'https://HOST/chat/api.php?c=0&u=1&msg=Test'

We have to look this. A registred user can create an api user and token pair to access the chat by them.



 