<?php

//require_once( __DIR__ . '/config.php' );
require_once( __DIR__ . '/class/Base.php' );
require_once( __DIR__ . '/class/Session.php' );
require_once( __DIR__ . '/class/Users.php' );

$session = new Session();
$users = new Users();

$uid = null;
$msg = null;
$output = null;

$notifyValues = array( '1' => 'Notifications Enabled', '0' => 'Notifications Disabled' );

$ip = Base::getIp();
$rid = $users->finByIp( $ip ); // [0]['id']
$rid = isset( $rid[0]['id'] ) ? $rid[0]['id'] : $session->readSession( 'id' );

// get an id if submitted one
if( isset( $_REQUEST['uid'] ) && $_REQUEST['uid'] != null && $_REQUEST['uid'] =! "" ) {
  $uid = $_GET['uid'];
}

// only logged in admins should open this page
// && ( $session->getRole( $session->readSession( 'id' ) ) !== null
if( $session->readSession( 'LogedIn' ) == 0 || ( $session->readSession( 'id' ) !== null && $session->getRole( $session->readSession( 'id' ) ) >= 20 ) ) {
  if( $session->readSession( 'id' ) != $uid ) {
    header( 'Location: ./' );
    exit;
  }
}



// unban user
if( ( isset( $_REQUEST['unban'] ) ) ) {
  // unban
  // $id = isset( $_REQUEST['id'] ) ? $_REQUEST['id'] : null;
  // if( $session->readSession( 'LogedIn' ) == 1 && $session->getRole( $id ) != null && $session->getRole( $id ) <= 10 && ) {
  if( $uid != null ) {
    $users->ban( $uid, false );
    header( 'Location: Users.php' );
    exit;
  }
}

// ban user
if( ( isset( $_REQUEST['ban'] ) ) ) {
  // ban
  // $id = isset( $_REQUEST['id'] ) ? $_REQUEST['id'] : null;
  if( $uid != null ) {
    $users->ban( $uid, true );
    header( 'Location: Users.php' );
    exit;
  }
}

// delete user
if( ( isset( $_REQUEST['delete'] ) ) ) {
  // delete
  if( $uid != null ) {
    $result = $users->deleteUser( $uid );
    if( $result ) {
      //$msg = array( 'suc' => 'Successful delete User ' . $uid );
      header( 'Location: Users.php' );
      exit;
    } else {
      $msg = array( 'err' => 'Unable to delete User ' . $uid );
    }
  }
}

if( isset( $_REQUEST['show'] ) && $_REQUEST['show'] != null && $_REQUEST['show'] =! "" ) {

  // show user and his data
  // should only visible for admins!
  // echo "show user: " . $uid;
  // os info
  // shares
  // open ports
  $sid = null;
  $banned = null;
  $mac = null;
  $host = null;
  $uagent = null;
  
  $name = null;
  $email = null;
  $notify = null;
  $password = null;
  $hashed = null;
  $role = null;
  //$roles = $users->getRoles();

  // if( isset( $_REQUEST['id'] ) && $_REQUEST['id'] != null && $_REQUEST['id'] != "" ) {
  //   $id = $_GET['id'];
  if( $session->readSession( 'LogedIn' ) == 1 && $session->getRole( $session->readSession( 'id' ) ) > 10 ) { // if no logged in admin
    if( $session->getRole( $session->readSession( 'id' ) ) !== "0" && $uid != $session->readSession( 'id' ) ) { // if another user id requested as the own
      header( 'Location: ./' );
      exit;
    }
  }
  // }


  $user = $users->readUser( $uid );
  
  // && $user[0]['id'] == $uid
  if( $user ) {
//    $id = $user[0]['id'];
    $name = $user[0]['name'];
    $email = $user[0]['email'];
    $notify = $user[0]['notify'];
    $password = null;
    $hashed = $user[0]['password'];
    $role = $user[0]['role'];
    $sid = $user[0]['sid'];
    $banned = $user[0]['banned'];
    $ip = $user[0]['ipAddr'];
    $mac = $user[0]['macAddr'];
    $host = $user[0]['host'];
    $uagent = $user[0]['uagent'];
  }

  $output  = "<div style='float:right;'>";
  if( $session->readSession( 'LogedIn' ) == 1 && $session->getRole( $session->readSession( 'id' ) ) != null && $session->getRole( $session->readSession( 'id' ) ) <= 10 ) {
    $output .= "<a href='Users.php?create=1'>Create</a> | ";
  }
  $output .= "<a href='Users.php'>Overview</a>";
  $output .= "</div>";
  
  $output .= "<h2><small><span class='glyphicon glyphicon-user' aria-hidden='true'></span></small> Show User Info</h2>";
  
  $output .= '<div class="card">';
  // $output .= '  <div class="card-header">Name: ' . $name . '</div>';
  $output .= '  <div class="card-body">';
  
  $output .= "    <table>";
  $output .= "      <thead>";
  $output .= "        <tr>";
  $output .= "          <th>Key</th>";
  $output .= "          <th>Value</th>";
  $output .= "        </tr>";
  $output .= "      </thead>";
  
  $output .= "      <tbody>";
  $output .= "        <tr>";
  $output .= "          <td>Name</td>";
  $output .= "          <td>" . $name . "</td>";
  $output .= "        </tr>";
  $output .= "      </tbody>";
  
  $output .= "      <tbody>";
  $output .= "        <tr>";
  $output .= "          <td>Email</td>";
  $output .= "          <td>" . $email . "</td>";
  $output .= "        </tr>";
  $output .= "      </tbody>";
  
  $output .= "      <tbody>";
  $output .= "        <tr>";
  $output .= "          <td>Notify</td>";
  $output .= "          <td>" . $notify . "</td>";
  $output .= "        </tr>";
  $output .= "      </tbody>";
  
  $output .= "      <tbody>";
  $output .= "        <tr>";
  $output .= "          <td>Password</td>";
  $output .= "          <td>" . $hashed . "...</td>"; // substr( $hashed, 0, 20 )
  $output .= "        </tr>";
  $output .= "      </tbody>";
  
  $output .= "      <tbody>";
  $output .= "        <tr>";
  $output .= "          <td>Role</td>";
  $output .= "          <td>" . $role . "</td>";
  $output .= "        </tr>";
  $output .= "      </tbody>";
  
  $output .= "      <tbody>";
  $output .= "        <tr>";
  $output .= "          <td>SID</td>";
  $output .= "          <td>" . $sid . "</td>";
  $output .= "        </tr>";
  $output .= "      </tbody>";
  
  $output .= "      <tbody>";
  $output .= "        <tr>";
  $output .= "          <td>Banned</td>";
  $output .= "          <td>" . $banned . "</td>";
  $output .= "        </tr>";
  $output .= "      </tbody>";
  
  $output .= "      <tbody>";
  $output .= "        <tr>";
  $output .= "          <td>IP</td>";
  $output .= "          <td>" . $ip . "</td>";
  $output .= "        </tr>";
  $output .= "      </tbody>";
  
  $output .= "      <tbody>";
  $output .= "        <tr>";
  $output .= "          <td>MAC</td>";
  $output .= "          <td>" . $mac . "</td>";
  $output .= "        </tr>";
  $output .= "      </tbody>";
  
  $output .= "      <tbody>";
  $output .= "        <tr>";
  $output .= "          <td>Hostname</td>";
  $output .= "          <td>" . $host . "</td>";
  $output .= "        </tr>";
  $output .= "      </tbody>";
  
  $output .= "      <tbody>";
  $output .= "        <tr>";
  $output .= "          <td>User Agent</td>";
  $output .= "          <td>" . $uagent . "...</td>"; // substr( $uagent, 0, 20 )
  $output .= "        </tr>";
  $output .= "      </tbody>";
  
  $output .= "    </table>";

  $output .= '  </div>'; // close card body
  $output .= '</div>'; // close card
  // $output .= '<div class="col-sm-12">';
  // $output .= 'UA String: ' . $uagent;
  // $output .= '</div>';
  
  
} else if( isset($_REQUEST['create'] ) && $_REQUEST['create'] != null && $_REQUEST['create'] =! "" ) {
  // create new user
  //echo "create new user: ";
  $name = null;
  $email = null;
  $notify = 1;
  $password = null;
  $role = null;
  $roles = $users->getRoles();
  
  if( isset( $_REQUEST['submit'] ) ) {
    
    if( isset( $_REQUEST['name'] ) && $_REQUEST['name'] != null && $_REQUEST['name'] != "" ) {
      $name = $_REQUEST['name'];
    }
    if( isset( $_REQUEST['password'] ) && $_REQUEST['password'] != null && $_REQUEST['password'] != "" ) {
      $password = $_REQUEST['password'];
    }
    if( isset( $_REQUEST['email'] ) && $_REQUEST['email'] != null && $_REQUEST['email'] != "" ) {
      $email = $_REQUEST['email'];
    }
    if( isset( $_REQUEST['notify'] ) && $_REQUEST['notify'] != null && $_REQUEST['notify'] != "" ) {
      $notify = $_REQUEST['notify'];
    }
    if( isset( $_REQUEST['role'] ) && $_REQUEST['role'] != null && $_REQUEST['role'] != "" ) {
      $role = $_REQUEST['role'];
    }

    if( $name === null ) {
      $msg = array( 'err' => "Failed to create User: empty username" );
    } else if( $password === null ) {
      $msg = array( 'err' => "Failed to create User: empty password" );
    } else if( $role === null ) {
      $msg = array( 'err' => "Failed to create User: empty role" );
    } else {
      $result = $users->createUser( $name, $password, $email, $notify, $role );

      if( $result && gettype( $result ) != 'string' ) {
        //$msg = array( 'suc' => "Successful created User " . $name );
        header( 'Location: Users.php' );
        exit;
      } else {
        if( gettype( $result ) === 'string' ) {
          $msg = array( 'err' => $result );
        } else {
          $msg = array( 'err' => "Failed to create User" );
        }
      }
    }
  } // end submit

  if( $msg === null || isset( $msg['err'] ) ) {
    $output  = "<div style='float:right;'>";
    if( $session->readSession( 'LogedIn' ) == 1 && $session->getRole( $session->readSession( 'id' ) ) != null && $session->getRole( $session->readSession( 'id' ) ) <= 10 ) {
      $output .= "<a href='Users.php?create=1'>Create</a> | ";
    }
    $output .= "<a href='Users.php'>Overview</a>";
    $output .= "</div>";
    $output .= "<h2><small><span class='glyphicon glyphicon-user' aria-hidden='true'></span></small> Create new User</h2>";
    $output .= "<div class='msg" . ( isset( $msg['err'] ) ? ' error' : '' ) . "'>" . $msg['err'] . "</div>";
    $output .= '<div class="col-sm-12">';
    $output .= "<form action='?create=1' method='post'>";
    $output .= " <formfield class='form-group'>";

    $output .= '    <div class="form-group">' . "\n";
    $output .= "      <label for='name'>Username:</label><br />";
    $output .= '  		<div class="col-sm-4">' . "\n";
    $output .= "        <input type='text' name='name' id='name' value='".$name."' /><br /><br />";
    $output .= '      </div>' . "\n";
    $output .= '    </div>' . "\n";

    $output .= '    <div class="form-group">' . "\n";
    $output .= "      <label for='password'>Password <br />(leave empty for no Change):</label><br />";
    $output .= '  		<div class="col-sm-4">' . "\n";
    $output .= "        <input type='password' name='password' id='password' value='".$password."' /><br /><br />";
    $output .= '      </div>' . "\n";
    $output .= '    </div>' . "\n";

    $output .= '    <div class="form-group">' . "\n";
    $output .= "      <label for='email'>E-Mail:</label><br />";
    $output .= '  		<div class="col-sm-4">' . "\n";
    $output .= "        <input type='email' name='email' id='email' value='".$email."' /><br /><br />";
    $output .= '      </div>' . "\n";
    $output .= '    </div>' . "\n";

    $output .= '    <div class="form-group">' . "\n";
    $output .= "      <label for='notify'>Browser Notifications:</label><br />";
    $output .= '  		<div class="col-sm-4">' . "\n";
    $output .= "        <select name='notify' id='notify'>";
    $selected = false; 
    
    foreach( $notifyValues as $key => $notifyValue ) {
      $active = $notify == $key ? ' selected="selected"' : '';
      $active = $selected ? '' : $active;
      $output .= "          <option value='" . $key . "'" . $active . ">" . $notifyValue . "</option>";
    }
    $output .= "        </select><br /><br />";
    $output .= '      </div>' . "\n";
    $output .= '    </div>' . "\n";

    // only visible for admins
    if( $session->getRole( $session->readSession( 'id' ) ) <= 10 ) {
      $output .= '    <div class="form-group">' . "\n";
      $output .= "      <label for='role'>Role:</label><br />";
      $output .= '  		<div class="col-sm-4">' . "\n";
      $output .= "        <select name='role' id='role'>";
      $selected = false;
      if( $role === null ) {
        $output .= "        <option value='' selected disabled hidden>Please choose</option>";
        $selected = true;
      } 
      foreach( $roles as $key => $roleValue ) {
        $active = $role == $key ? ' selected="selected"' : ''; // " . $active . "
        $output .= "       <option value='" . $key . "'" . $active . ">" . $roleValue . "</option>";
      }
      $output .= "        </select><br /><br />";
      $output .= '      </div>' . "\n";
      $output .= '    </div>' . "\n";
    }
    
    $output .= " </formfield>";
    
    $output .= '  <div class="form-group">' . "\n";
    $output .= '    <div class="col-sm-offset-2 col-sm-4">' . "\n";
    $output .= '      <button id="btnSave" type="submit" name="submit" class="btn btn-default btn-red">' . "\n";
    $output .= '        <span class="glyphicon glyphicon-saved"></span> Save' . "\n";
    $output .= '      </button>' . "\n";
    $output .= '    </div>' . "\n";
    $output .= '  </div>';
    
    $output .= "</form>";
    $output .= "</div>";
  } // end create form
  
} else if( isset( $_REQUEST['edit'] ) && $_REQUEST['edit'] != null && $_REQUEST['edit'] =! "" ) {
  // edit user

//   $id = null;

  $sid = null;
  $banned = null;
  $mac = null;
  $host = null;
  $uagent = null;
  
  $name = null;
  $email = null;
  $notify = null;
  $password = null;
  $hashed = null;
  $role = null;
  $roles = $users->getRoles();

  // if( isset( $_REQUEST['id'] ) && $_REQUEST['id'] != null && $_REQUEST['id'] != "" ) {
  //   $id = $_GET['id'];
  if( $session->readSession( 'LogedIn' ) == 1 && $session->getRole( $session->readSession( 'id' ) ) > 10 ) { // if no logged in admin
    if( $session->getRole( $session->readSession( 'id' ) ) !== "0" && $uid != $session->readSession( 'id' ) ) { // if another user id requested as the own
      header( 'Location: ./' );
      exit;
    }
  }
  // }


  $user = $users->readUser( $uid );
  
  // && $user[0]['id'] == $uid
  if( $user ) {
//    $id = $user[0]['id'];
    $name = $user[0]['name'];
    $email = $user[0]['email'];
    $notify = $user[0]['notify'];
    $password = null;
    $hashed = $user[0]['password'];
    $role = $user[0]['role'];
    $sid = $user[0]['sid'];
    $banned = $user[0]['banned'];
    $ip = $user[0]['ipAddr'];
    $mac = $user[0]['macAddr'];
    $host = $user[0]['host'];
    $uagent = $user[0]['uagent'];
  }

  if( isset( $_REQUEST['submit'] ) ) {
    // get data and create user
    if( isset( $_REQUEST['name'] ) && $_REQUEST['name'] != null && $_REQUEST['name'] != "" ) {
      $name = $_REQUEST['name'];
    }
    if( isset( $_REQUEST['password'] ) && $_REQUEST['password'] != null && $_REQUEST['password'] != "" ) {
      $password = $_REQUEST['password'];
      $hashed = hash( 'sha256', SECRET . $password );
    }
    if( isset( $_REQUEST['email'] ) && $_REQUEST['email'] != null && $_REQUEST['email'] != "" ) {
      $email = $_REQUEST['email'];
    }
    if( isset( $_REQUEST['notify'] ) && $_REQUEST['notify'] != null && $_REQUEST['notify'] != "" ) {
      $notify = $_REQUEST['notify'];
      $notify = $notify == 'on' ? 1 : 0;
    }

    // only visible for admins
    if( isset( $_REQUEST['role'] ) && $_REQUEST['role'] != null && $_REQUEST['role'] != "" ) {
      $role = $_REQUEST['role'];
    }
    if( isset( $_REQUEST['sid'] ) && $_REQUEST['sid'] != null && $_REQUEST['sid'] != "" ) {
      $sid = $_REQUEST['sid'];
    }
    if( isset( $_REQUEST['banned'] ) && $_REQUEST['banned'] != null && $_REQUEST['banned'] != "" ) {
      $banned = $_REQUEST['banned'];
    }
    if( isset( $_REQUEST['ip'] ) && $_REQUEST['ip'] != null && $_REQUEST['ip'] != "" ) {
      $ip = $_REQUEST['ip'];
    }
    if( isset( $_REQUEST['mac'] ) && $_REQUEST['mac'] != null && $_REQUEST['mac'] != "" ) {
      $mac = $_REQUEST['mac'];
    }
    if( isset( $_REQUEST['host'] ) && $_REQUEST['host'] != null && $_REQUEST['host'] != "" ) {
      $host = $_REQUEST['host'];
    }
    if( isset( $_REQUEST['uagent'] ) && $_REQUEST['uagent'] != null && $_REQUEST['uagent'] != "" ) {
      $uagent = $_REQUEST['uagent'];
    }

    $result = $users->updateUser( $uid, $name, $hashed, $email, $notify, $role, $sid, $banned, $ip, $mac, $host, $uagent );

    if( $result && gettype( $result ) != 'string' ) {
      if( $session->readSession( 'id' ) == $uid ) {
        $session->writeSession( 'user', $name );
      }
      header( 'Location: Users.php' );
      exit;
    } else {
      if( gettype( $result ) == 'string' ) {
        $msg = array( 'err' => $result );
      } else {
        $msg = array( 'err' => "Failed to edit User" );
      }
    }

  } // end submit

  if( $msg === null || isset( $msg['err'] ) ) {
    // show the create Form
    $output  = "<div style='float:right;'>";
    if( $session->readSession( 'LogedIn' ) == 1 && $session->getRole( $session->readSession( 'id' ) ) != null && $session->getRole( $session->readSession( 'id' ) ) <= 10 ) {
      $output .= "<a href='Users.php?create=1'>Create</a> | ";
    }
    $output .= "<a href='Users.php'>Overview</a>";
    $output .= "</div>";
    $output .= "<h2><small><span class='glyphicon glyphicon-user' aria-hidden='true'></span></small> Edit user " . $name . "</h2>";
    $output .= "<div class='msg" . ( isset( $msg['err'] ) ? ' error' : '' ) . "'>" . $msg['err'] . "</div>";
//    $output .= "<div class='row'>";
    $output .= '<div class="col-sm-12">';
    $output .= "<form action='?edit=1&uid=" . $uid . "' method='post'>";
    $output .= " <formfield class='form-group'>";
//    $output .= '    <legend>Userdata</legend>' . "\n";
    
    $output .= '    <div class="form-group">' . "\n";
    $output .= "      <label for='name'>Username:</label><br />";
    $output .= '  		<div class="col-sm-4">' . "\n";
    $output .= "        <input type='text' name='name' id='name' value='".$name."' /><br /><br />";
    $output .= '      </div>' . "\n";
    $output .= '    </div>' . "\n";
    
    $output .= '    <div class="form-group">' . "\n";
    $output .= "      <label for='password'>Password <br />(leave empty for no Change):</label><br />";
    $output .= '  		<div class="col-sm-4">' . "\n";
    $output .= "        <input type='password' name='password' id='password' value='".$password."' /><br /><br />";
    $output .= '      </div>' . "\n";
    $output .= '    </div>' . "\n";
    
    $output .= '    <div class="form-group">' . "\n";
    $output .= "      <label for='email'>E-Mail:</label><br />";
    $output .= '  		<div class="col-sm-4">' . "\n";
    $output .= "        <input type='email' name='email' id='email' value='".$email."' /><br /><br />";
    $output .= '      </div>' . "\n";
    $output .= '    </div>' . "\n";

    // show th Notifications Button only if the user is the same as requested
    if( $uid == $session->readSession( 'id' ) ) {
//      $output .= gettype( $notify );
      $notifyChecked = $notify == 1 ? 'checked' : '';
      $output .= '    <div class="form-group">' . "\n";
      $output .= "      <label for='notify'>Browser Notifications (".$notify."):</label><br />";
      $output .= '  		<div class="col-sm-4">' . "\n";
      $output .= '        <input type="checkbox" id="notify" name="notify" value="'.$notify.'" onclick="notifyMe( this )" '.$notifyChecked.'><br /><br />'; // javascript button value="'.$notify.'"
      $output .= '      </div>' . "\n";
      $output .= '    </div>' . "\n";
    } else {
      // admins can set also notifications for users
      $output .= '    <div class="form-group">' . "\n";
      $output .= "      <label for='notify'>Browser Notifications:</label><br />";
      $output .= '  		<div class="col-sm-4">' . "\n";
      $output .= "        <select name='notify' id='notify'>";
      $notifyValues = array( '0' => 'Notifications Disabled', '1' => 'Notifications Enabled' );
      foreach( $notifyValues as $key => $notifyValue ) {
        $active = $notify == $key ? ' selected="selected"' : '';
        $output .= "          <option value='" . $key . "'" . $active . ">" . $notifyValue . "</option>";
      }
      $output .= "        </select><br /><br />";
      $output .= '      </div>' . "\n";
      $output .= '    </div>' . "\n";
    }

    // only visible for admins
    if( $session->getRole( $session->readSession( 'id' ) ) <= 10 ) {
      $output .= '    <div class="form-group">' . "\n";
      $output .= "      <label for='role'>Role:</label><br />";
      $output .= '  		<div class="col-sm-4">' . "\n";
      $output .= "        <select name='role' id='role'>";
      foreach( $roles as $key => $roleValue ) {
        $active = $role == $key ? ' selected="selected"' : '';
        $output .= "       <option value='" . $key . "'" . $active . ">" . $roleValue . "</option>";
      }
      $output .= "        </select><br /><br />";
      $output .= '      </div>' . "\n";
      $output .= '    </div>' . "\n";
      
      $output .= '    <div class="form-group">' . "\n";
      $output .= "      <label for='sid'>SID:</label><br />";
      $output .= '  		<div class="col-sm-4">' . "\n";
      $output .= "        <input type='text' name='sid' id='sid' value='".$sid."' /><br /><br />";
      $output .= '      </div>' . "\n";
      $output .= '    </div>' . "\n";
      
      $output .= '    <div class="form-group">' . "\n";
      $bannedValues = array( '0' => 'Unban', '1' => 'Ban' );
      $output .= "      <label for='banned'>Banned:</label><br />";
      $output .= '  		<div class="col-sm-4">' . "\n";
      $output .= "        <select name='banned' id='banned'>";
      foreach( $bannedValues as $key => $bannedValue ) {
        $active = $banned == $key ? ' selected="selected"' : '';
        $output .= "          <option value='" . $key . "'" . $active . ">" . $bannedValue . "</option>";
      }
      $output .= "        </select><br /><br />";
      $output .= '      </div>' . "\n";
      $output .= '    </div>' . "\n";

      $output .= '    <div class="form-group">' . "\n";
      $output .= "      <label for='ip'>IP:</label><br />";
      $output .= '  		<div class="col-sm-4">' . "\n";
      $output .= "        <input type='text' name='ip' id='ip' value='".$ip."' /><br /><br />";
      $output .= '      </div>' . "\n";
      $output .= '    </div>' . "\n";

      $output .= '    <div class="form-group">' . "\n";
      $output .= "      <label for='mac'>MAC:</label><br />";
      $output .= '  		<div class="col-sm-4">' . "\n";
      $output .= "        <input type='text' name='mac' id='mac' value='".$mac."' /><br /><br />";
      $output .= '      </div>' . "\n";
      $output .= '    </div>' . "\n";

      $output .= '    <div class="form-group">' . "\n";
      $output .= "      <label for='host'>Hostname:</label><br />";
      $output .= '  		<div class="col-sm-4">' . "\n";
      $output .= "        <input type='text' name='host' id='host' value='".$host."' /><br /><br />";
      $output .= '      </div>' . "\n";
      $output .= '    </div>' . "\n";
    }
    // $output .= "   <input type='submit' name='submit' value='Submit' /><br />";
    $output .= " </formfield>";
    $output .= '  <div class="form-group">' . "\n";
    $output .= '    <div class="col-sm-offset-2 col-sm-4">' . "\n";
    $output .= '      <button id="btnSave" type="submit" name="submit" class="btn btn-default btn-red">' . "\n";
    $output .= '        <span class="glyphicon glyphicon-saved"></span> Save' . "\n";
    $output .= '      </button>' . "\n";
    $output .= '    </div>' . "\n";
    $output .= '  </div>';
    $output .= "</form>";
    $output .= "</div>";
  } // end edit form
  
} else {
  
  // list all
  
  $userlist = $users->listUsers();
  
  $output  = "<div style='float:right;'>";
  if( $session->readSession( 'LogedIn' ) == 1 && $session->getRole( $session->readSession( 'id' ) ) != null && $session->getRole( $session->readSession( 'id' ) ) <= 30 ) {
    $output .= "<a href='./Users.php?create=1'>Create</a> | ";
  }
  $output .= "<a href='Users.php'>Overview</a>";
  $output .= "</div>";
  $output .= "<h2><small><span class='glyphicon glyphicon-user' aria-hidden='true'></span></small> Users Overview</h2>";

  $output .= "<div class='msg" . ( isset( $msg['err'] ) ? ' err' : '' ) . "'>" . $msg['err'] . "</div>";
  $output .= "<div class='row'>";
  $output .= "<table class='table'>";
  $output .= "<tr>";
  $output .= "  <th>ID</th>";
  $output .= "  <th>Name</th>";
  $output .= "  <th>Online</th>";
  $output .= "  <th>Notify</th>";
  // $output .= "  <th>E-Mail</th>";
  $output .= "  <th>Role</th>";
  // $output .= "  <th>IP</th>";
  // $output .= "  <th>MAC</th>";
  $output .= "  <th>Actions</th>";
  $output .= "</tr>";
  foreach( $userlist as $key => $user ) {
    //$online = isset( $user['sid'] ) && $user['sid'] != null && ! empty( $user['password'] ) ? 'online' : 'offline'; // todo get online state
    $online = $users->isOnline( $user['id'] ) ? 'on' : 'off';
    $output .= "<tr>";
    $output .= "<td>" . $user['id'] . "</td>";
    //$output .= "<td>" . $user['name'] . "</td>";
    $output .= "<td><a href='?show=1&uid=" . $user['id'] . "'>" . $user['name'] . "</a></td>";
    $output .= "<td>" . $online . "</td>";
    $output .= "<td>" . $user['notify'] . "</td>";
    // $output .= "<td>" . $user['email'] . "</td>";
    $output .= "<td>" . $users->getRoleNameById( $user['role'] ) . "</td>";
//    $output .= "<td>" . $user['role'] . "</td>";
    // $output .= "<td>" . $user['host'] . "</td>";
    // $output .= "<td>" . $user['ipAddr'] . "</td>";
    // $output .= "<td>" . $user['macAddr'] . "</td>";
    // $output .= "<td>" . $user['sid'] . "</td>";
    // $output .= "<td>" . $user['password'] . "</td>";
    $output .= "<td>";
    $output .= "<a href='Users.php?edit=1&uid=".$user['id']."'>Edit</a>";
    if( $user['role'] != 0 ) { // the current user (admin) cannot delete oder ban his self ... $user['role'] != 0 || $user['id'] != $uid 
      if( $user['banned'] == '1' ) {
        $output .= " | <a href='Users.php?unban=1&uid=".$user['id']."'>Unban</a> | ";
      } else {
        $output .= " | <a href='Users.php?ban=1&uid=".$user['id']."'>Ban</a> | ";
      }
      $output .= "<a href='Users.php?delete=1&uid=".$user['id']."' onclick=\"return confirm('Delete chat " . $user['name'] . "?')\">Delete</a>";
    }
    $output .= "</td>";
    $output .= "</tr>";
  }
  $output .= "</table>";
  $output .= "</div>";
}

?>
<!DOCTYPE html>
<html lang="en">
<?php require_once( __DIR__ . '/tpl/head.php' ) ?>
<body>

<?php require_once( __DIR__ . '/tpl/header.php' ) ?>


<div class="container">

  <div class="maincont">
    
<?php

// print output
echo $output;

?>

  </div>
  
</div>

<?php require_once( __DIR__ . '/tpl/footer.php' ) ?>

</body>
</html>