<?php

class Base {
  
  /**
   * millisec since 01.01.1970 00:00:00.000
   */
  static public function milliseconds() {
    $mt = explode(' ', microtime());
    return ( (int) $mt[1] ) * 1000 + ( (int) round( $mt[0] * 1000 ) );
  }
  
  /**
   * application date format
   * default style: 1970-01-01 00:00:00.000
   */
  static public function date( $format = null ) {
    if( $format === null ) $format = 'Y-m-d H:i:s'; 
    return date( $format ) . "." . substr( self::milliseconds(), -3 );
  }
  
  /**
   * get the client IP, ipv6 2 ipv4 by ping hostname)
   */
  static public function getIp() {
    $ip = $_SERVER['REMOTE_ADDR'];
    if( strpos( $ip, ':' ) !== false ) { // check if host is reachable via IPv4 to get this IP
      $host = gethostbyaddr( $ip );
      $ip = shell_exec( 'ping -c 1 -t 1 -q ' . $host . ' | grep -E -o "([0-9]{1,3}[\.]){3}[0-9]{1,3}" | tr -d "\n"' );
    }
    return $ip;
  }

  /**
   * get mac Address from local arp table
   */
  static public function getMac() {
    $ip = self::getIp();
    if( $ip === "127.0.0.1" ) {
      $mac = shell_exec( "ifconfig |grep -A10 \"$ip\" | grep \"ether\" | awk '{print $2}' | tr -d \"\n\"" );
    } else {
      $mac = shell_exec( "arp -a | grep $ip | awk '{print $4}' | tr -d \"\n\"" );
    }
    return $mac;
  }

  /**
   * read from a file
   */
  static public function readFromFile( $file = null ) {
    if( $file === null ) return false;
		$handle = fopen( $file, 'r' ); 
		$chattext = fread( $handle, filesize( $file ) ); 
    fclose( $handle );
    return $chattext;
  }
  
  /**
   * write data to a file
   */
  static public function writeToFile( $file = null, $data = null ) {
    if( $file === null || $data == null ) return false;
    $handle = fopen( $file, 'w' ); 
    $result = fwrite( $handle, $data ); 
    fclose( $handle );
    return $result;
  }
  
	/**
	 * Helper simple counting of current Security Level
	 */
	public static function secLvlHtml() { 
		// secLvl Bootstrap formating
		$level = self::secLvl();
		$status = '';
		$result = '';
		if( $level <= 1 ) {
			// status danger
			$status = 'text-danger';
		} else if( $level <= 2 ) {
			// status warning
			$status = 'text-warning';
		} else {
			// status ok
			$status = 'text-success';
		}
		$result .= '<div id="secLvl" style="display:inline;" title="Aktueller Sicherheitslevel der Anwendung: ' . $level . '">';
		for ( $i = 0; $i < $level; $i++ ) {
			$result .= '<span class="' . $status . ' glyphicon glyphicon-ok"></span> ';
		}
		if( $level == 0 ) $result .= '<span class="text-danger glyphicon glyphicon-remove"></span> ';
		$result .= '</div>';
		return $result;
	}
	
	
	/**
	 * Helper simple counting of current Security Level
	 */
	public static function secLvl() { 
		$result = 0;
		if( strpos( PROTOCOL, 'ttps' ) !== false ) $result++;			  // https					+1
		//$result += Config::get( 'seclvl' );													// seclvl					+seclvl
		//$result += round( strlen( Config::get( 'token' ) ) / 8 );	// token length		each8 +1
		$result += round( strlen( SECRET ) / 8 );	// secret length	each8 +1
		//if( Config::get( 'apiredirect' ) ) $result++;								// apiredirect		+1
		return $result;
	}
  
	/**
	 * Generate a Token (URL save characters)
	 * Form 0 = only Numbers
	 * Form 1 = only Letters
	 * Form 2 = Letters and Numbers
	 * Form 3 = Letters, Numbers and special Characters
	 * @param $length Integer 
	 * @param $form Integer
	 * @return String
	 */
	public static function genToken( $length = null, $form = null ) {
		if( $length === null ) 	$length = 32;	// default length
		if( $form === null ) 		$form = 2;		// default form
		$num 			= array( '0','1','2','3','4','5','6','7','8','9' );
		$letters 	= array( 'a','b','c','d','e','f','g','h','i','j','k','l','m',
											 'n','o','p','q','r','s','t','u','v','w','x','y','z',
											 'A','B','C','D','E','F','G','H','I','J','K','L','M',
											 'N','O','P','Q','R','S','T','U','V','W','X','Y','Z' );
		$numchars = array( '0','1','2','3','4','5','6','7','8','9','!','(',')','-','_' );
		if( $form == 0 ) {
			$tmpArr = $num;
		} elseif( $form == 1 ) {
			$tmpArr = $letters;
		} elseif( $form == 2 ) {
			$tmpArr = $num + $letters;
		} elseif( $form == 3 ) {	
			$tmpArr = $numchars + $letters;
		} 
		$passArr = $tmpArr;
		$passwd = "";
		$last = '';
		for ($i = 0; $i < $length; $i++) {
			shuffle($passArr);
			if( $last != $passArr[$i] ) { 
				$passwd .= $passArr[$i]; 
			} else { 
				$i -1;
			}
			$last = $passArr[$i];
		}
		return $passwd;
	}
	
	
	/**
	 * get a token ( from string or if no string is given from app config secret)
	 */
	public static function token( $string = null ) {
    if( $string === null ) $string = self::genToken( 16, 2 );
    return base64_encode( sha1( $string . SECRET, true ) );
	}

	
	/**
	 * Helper function to encrypt data (strings, arrays, etc)
	 */
	public static function encrypt( $string = null, $appToken = null ) {
    if( $string === null || $string === "" ) return false;
    // if( $appToken === null ) $appToken = Config::get( 'secret', $_SESSION['site'] );
    // return base64_encode( mcrypt_encrypt( MCRYPT_RIJNDAEL_256, $appToken, json_encode( $string ), MCRYPT_MODE_ECB ) );
	}


	/**
	 * Helper function to decrypt crypted data string
	 */
	public static function decrypt( $cryptedString = null, $appToken = null ) {
		if( $cryptedString === null || $cryptedString === "" ) return false;
    // if( $appToken === null ) $appToken = Config::get( 'secret', $_SESSION['site'] );
    // return json_decode( trim( mcrypt_decrypt( MCRYPT_RIJNDAEL_256, $appToken, base64_decode( $cryptedString ), MCRYPT_MODE_ECB ) ) );
	}
  
  
  
	//
	// System data 
	//
	
  /**
   * Main collection
   */
	public static function getAll() {
		$data['host'] = self::getHost();
		$data['mem'] = self::getMem();
		$data['load'] = self::getLoad();
		$data['fs'] = self::getFs();
		$data['net'] = self::getNet();
    $data['git'] = self::gitAll();
		return $data;
	}
	
  /**
   * Hostdata
   */
	public static function getHost() {
		$host['name'] = shell_exec('hostname | tr -d "\n"');
		$host['kernel'] = shell_exec('uname -r | tr -d "\n"');
    $host['cputemp'] = self::getCpuTemp();
//    $host['updates'] = self::getUpdates();
    $host['files'] = self::totalFiles();
    $host['env'] = self::getEnv();
    $host['uptime'] = self::getUptime();
		return $host;
	}

  /**
   * system CPU Temperature
   */
	public static function getCpuTemp() {
    if( is_file( '/sys/class/thermal/thermal_zone0/temp' ) ) {
      $soc_temp_raw = shell_exec( 'cat /sys/class/thermal/thermal_zone0/temp' );
      $soc_temp_raw = substr( $soc_temp_raw, 0, 2 ) . "." . substr( $soc_temp_raw, 2, -3 );
    } else if( is_file( '/usr/local/bin/osx-cpu-temp' ) ) {
      $soc_temp_raw = shell_exec( '/usr/local/bin/osx-cpu-temp | tr -d "°C" | tr -d "\n"' );
    } else {
      $soc_temp_raw = "0.0";
    }
		return $soc_temp_raw;
		
	}

  /**
   * system RAM usage
   */
	public static function getMem() {
    $mem = null;
    if( is_file( '/proc/meminfo' ) ) {
      // linux
  		$mem['total'] = shell_exec( 'cat /proc/meminfo | grep MemTotal | grep -o "[0-9]\+" | tr -d "\n"' );			// Total Memory in kB
  		$mem['free'] = shell_exec( 'cat /proc/meminfo | grep MemFree | grep -o "[0-9]\+" | tr -d "\n"' );				// Free Memory in kB
  		$mem['avail'] = shell_exec( 'cat /proc/meminfo | grep MemAvailable | grep -o "[0-9]\+" | tr -d "\n"' );	// Available Memory in kB
  		$mem['percent'] = isset( $mem['total'] ) && isset( $mem['avail'] ) ? round( ( 100 / $mem['total'] ) * $mem['avail'] ) : "" . "%"; // Free memory in %
    } else {
      // osx
      
    }
		return $mem;
	}

  /**
   * system uptime
   */
	public static function getUptime() {
		$uptime= shell_exec('uptime | cut -f1 -d"," | tr -d "\n"');
		return $uptime;
	}

  /**
   * system load
   */
	public static function getLoad() {
    if( is_file( '/proc/loadavg' ) ) {
      // linux
      $loadavgout = shell_exec('cat /proc/loadavg'); // else use uptime
      if( $loadavgout === null ) return 'unavailable';
  		$loadavgArr = explode(" ", $loadavgout);
  		$schedulingArr = explode("/", $loadavgArr[3]);
  		$avg['avg1'] = $loadavgArr[0];			// average systemload last 1m
  		$avg['avg5'] = $loadavgArr[1];			// average systemload last 5m
  		$avg['avg15'] = $loadavgArr[2];			// average systemload last 15m
  		$avg['active'] = $schedulingArr[0];	// number of active tasks
  		$avg['total'] = isset( $schedulingArr[1] ) ? $schedulingArr[1] : null;	// number of total tasks
    } else {
      // osx
      $loadavgout = shell_exec( "uptime | tail -c 17 | tr -d \":\" | sed -e 's/, / /g' | tr -d \"\n\"" ); // else use uptime
      if( $loadavgout === null ) return 'unavailable';
  		$loadavgArr = explode(" ", $loadavgout);
//  		$schedulingArr = explode("/", $loadavgArr[3]);
  		$avg['avg1'] = $loadavgArr[1];			// average systemload last 1m
  		$avg['avg5'] = $loadavgArr[2];			// average systemload last 5m
  		$avg['avg15'] = $loadavgArr[3];			// average systemload last 15m
  		$avg['active'] = shell_exec( "ps axc | awk '{ if( $3 == \"S\" ) print $3}' | wc -l | tr -d \" \" | tr -d \"\n\"" );	// number of active tasks
  		$avg['total'] = shell_exec( 'ps axc | sed "s/.*:..... /\"/" | sed s/$/\"/ | uniq | wc -l | tr -d " " | tr -d "\n"' );	// number of total tasks
    }
    
		return $avg;
	}

  /**
   * system filesystem data
   */
	public static function getFs() {
		$filesysout = shell_exec('df -h | grep root | tr -s " "');
    if( $filesysout === null ) return 'unavailable';
		$filesysArr = explode( " ", $filesysout );
		$fs['total'] = $filesysArr[1];		// Filesystem Total space
		$fs['used'] = $filesysArr[2];			// Filesystem Used space
		$fs['free'] = $filesysArr[3];			// Filesystem Free space
		$fs['percent'] = $filesysArr[4];	// Filesystem Used space %
		return $fs;
	}

  /**
   * system Network Devices
   */
	public static function getNet() {
		$net['ip'] = shell_exec( '/sbin/ifconfig eth0 | grep \'inet addr:\' | cut -d: -f2 | awk \'{ print $1}\' | tr -d "\n"' );
		$netin = shell_exec( '/sbin/ifconfig | grep -m 1 "RX bytes" | awk -F "[()]" \'{print $2}\' | tr -d "\n"' );
		$net['in'] = ( strpos( $netin, 'GiB' ) !== false ) ? $netin = str_replace( ' GiB', '', $netin ) * 1024 . ' MiB' : $netin;
		$netout = shell_exec( '/sbin/ifconfig | grep -m 1 "RX bytes" | awk -F "[()]" \'{print $4}\' | tr -d "\n"' );
		$net['out'] = ( strpos( $netout, 'GiB' ) !== false ) ? $netout = str_replace( ' GiB', '', $netout ) * 1024 . ' MiB' : $netout;
		return $net;
	}

  /**
   * system paketmanager updates
   */
	public static function getUpdates() {
		// has long runtime, request this only asyncron via ajax!!!
    $updates = shell_exec( 'sudo /usr/lib/update-notifier/update-motd-updates-available | grep -Eo \'[0-9]{1,3}\' | tr \'\n\' \'/\' | cut -d \'/\' -f1,2' );
    // // apt-get install update-notifier-common (for apt-check)
    $updates = shell_exec( 'sudo /usr/lib/update-notifier/apt-check' );
    $updates = shell_exec( "LANG=C apt-get upgrade -s | grep -P '^\d+ upgraded' | cut -d \" \" -f1 | tr -d \"\n\"" );
    return isset( $updates ) ? $updates : 0;
	}
  
	/**
	 * System Reboot
	 */
  public static function restart() {
		return shell_exec( 'sudo /sbin/shutdown -r now' );
  }

	/**
	 * System shutdown
	 */
  public static function shutdown() {
    return shell_exec( 'sudo /sbin/shutdown -h now' );
  }
  
}

?>