<?php

require_once( __DIR__ . '/Base.php' );

class Chat extends Base {
  
  public $_type = 'SQLite';
  public $_table = null;
  public $_db = null;
  
  public function __construct() {
    try {
      $this->_table = strtolower( get_class( $this ) );
      // file or db?
      require_once( __DIR__ . '/../config.php' );
      if( SQLITE_TYPE == 'FILE' ) {
        // is file?
        // is writeable?
        require_once( __DIR__ . '/Database.php' );
        $this->_db = new Database( $this->_type );
        if( ! is_file( SQLITE_FILE ) ) {
  				$string  = "File " . SQLITE_FILE . " does not exists, please run the following commands in you tty terminal.<br /><br />";
          $string .= "1. create the Database by:<br />";
          $string .= "sudo sqlite3 " . dirname( $dbfile ). "<br /><br />";
          $string .= "2. in the opened sqlite session enter the following sql statement (replace <TABLENAME> by your table!) and hit enter:";
          $string .= "CREATE TABLE " . $this->_table . " ( 'id' INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, 'name' TEXT NULL, 'email' TEXT NULL );";
          throw new Exception( $string );
        }
        if( $this->_type === 'SQLite' && SQLITE_TYPE === 'FILE' && ! is_writeable( SQLITE_FILE ) ) {
          $serverusername = posix_getpwuid(posix_geteuid());
          throw new Exception( "SQLite file not writeable by webserver user, please add write permissions to file and Folder! <br />sudo chown -R " . $serverusername['name'] . " " . dirname( SQLITE_FILE ). "<br />" );
        }
        
        // check Database connection
        if( ! $this->_db->connection() ) {
        	if ( SQLITE_TYPE === 'MEMORY' ) {
        		throw new Exception( "SQLite type: <strong>" . SQLITE_TYPE . "</strong> is not full implemented. <br />See <a href='https://www.sqlite.org/inmemorydb.html'>https://www.sqlite.org/inmemorydb.html</a> for example. <br /><br />No Database connection available, abort script. <br />" );
        	}
        }
        // does table exists?
        $query = "SELECT count(*) as sum FROM sqlite_master WHERE type='table' AND name='" . $this->_table . "';";
        $this->_db->query( $query );
        $this->_db->execute();
        $result = $this->_db->resultset();
        if( $result[0]['sum'] == "0" ) {
          // table does not exists
          if( ! $this->createDB() ) {
            throw new Exception( 'Unable to create Table ' . $this->_table );
          }
        }
        
      }
      
    } catch (Exception $e) {
      echo "<pre>";
      print_r( $e->getMessage() );
      echo "</pre>";
    }
    
  }
  
  public function dropDB() {
    $result = null;
    try {
      $query = "DROP TABLE IF EXISTS $this->_table";
      $this->_db->query( $query );
      $result = $this->_db->execute();
    } catch (Exception $e) {
      echo "<pre>";
      print_r( $e->getMessage() );
      echo "</pre>";
    }
    return $result;
  }

  public function createDB() {
    $result = null;
    try {
      $this->dropDB();
      $query = "CREATE TABLE $this->_table ( 
        'id' INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
        'chats_id' INTEGER NOT NULL,
        'users_id' INTEGER NOT NULL,
        'text' TEXT NULL,
        'created' TEXT NULL,
        FOREIGN KEY( chats_id ) REFERENCES chats( id ),
        FOREIGN KEY( users_id ) REFERENCES users( id )
      )";
      $this->_db->query( $query );
      $result = $this->_db->execute();
      if( $result ) {
        // insert main chat room 0
        $query = "INSERT INTO " . $this->_table . " VALUES( 0, 0, 0, '".DEFAULTXT."', '" . Base::date() . "' );";
        $this->_db->query( $query );
        $result = $this->_db->execute();
        if( ! $result ) {
          throw new Exception( 'Failed to insert First Chatroom Entry into Database!' );
        }
      }
      return true;
    } catch (Exception $e) {
      echo "<pre>";
      print_r( $e->getMessage() );
      echo "</pre>";
    } 
    return false;
  }
  
  public function createEntry( $cid = null, $uid = null, $text = null ) {
    if( ! is_numeric( $cid ) || ! is_numeric( $uid ) ) return false;
    $id = $this->getNextId();
    $created = Base::date();
    $query = "INSERT INTO " . $this->_table . " VALUES ( ".$id.", ".$cid.", ".$uid.", '".$text."', '".$created."' );";
    $this->_db->query( $query );
    $result = $this->_db->execute();
    if( $result != null && $result ) {
      // inform all other online clients
      return $id;
    }
    return false;
  }

  public function getChatText( $cid = null ) {
    if( $cid === null || ! is_numeric( $cid ) ) return false;
    if( $cid === null ) return false;
    $query = "SELECT * FROM " . $this->_table . " WHERE chats_id = " . $cid;
    $this->_db->query( $query );
    $result = $this->_db->execute();
    return $this->_db->resultset();
  }
  
  public function getChatUsers( $cid = null ) {
    if( ! is_numeric( $cid ) ) return false;
    $query = "SELECT id, users_id FROM " . $this->_table . " WHERE chats_id = " . $cid;
    $this->_db->query( $query );
    $result = $this->_db->execute();
    return $this->_db->resultset();
  }
  
  public function cleanUp( $input = null ) {
    if( $input === null ) return false;
    $result = null;

      $result['created'] = $input['created'];
      $result['users_id'] = $input['users_id'];
      $result['text'] = $input['text'];

    return $result;
  }

  public function readEntryById( $id = null ) {
    if( $id === null || ! is_numeric( $id ) ) return false;
    $query = "SELECT * FROM " . $this->_table . " WHERE id = " . $id;
    $this->_db->query( $query );
    $result = $this->_db->execute();
    return $this->_db->resultset()[0];
  }

  public function getUserNameById( $id = null ) {
    if( $id === null ) return false;
    require_once( __DIR__ . '/Users.php' );
    $users = new Users();
    $user = $users->readUser( $id );
    if( isset( $user[0] ) ) {
      return $user[0]['name'];
    }
    return 'deleted';
  }

  public function getNextId() {
    $query = "SELECT max(id) as id FROM " . $this->_table;
    $this->_db->query( $query );
    $this->_db->execute();
    $result = $this->_db->resultset();
    return $result[0]['id'] +1;
  }

  public function hasEntries( $cid = null ) {
    if( $cid === null ) return false;
    $query = "SELECT id FROM " . $this->_table . " WHERE chats_id = " . $cid;
    $this->_db->query( $query );
    $this->_db->execute();
    $result = $this->_db->resultset();
    if( isset( $result[0] ) ) {
      return true;
    }
    return false;
  }

  public function search( $search = null ) {
    if( $search === null ) return false;
    $query = "SELECT * FROM " . $this->_table . " WHERE text like '%" . $search . "%';";
    $this->_db->query( $query );
    $this->_db->execute();
    $result = $this->_db->resultset();
    return $result;
  }

  public function deleteChatById( $cid = null ) {
    if( $cid === null || ! is_numeric( $cid ) ) return false;
    if( $cid === null ) return false;
    $query = "DELETE FROM " . $this->_table . " WHERE chats_id = " . $cid;
    $this->_db->query( $query );
    $result = $this->_db->execute();
    return $result;
  }
  
}

?>