<?php

require_once( __DIR__ . '/../config.php' );
require_once( __DIR__ . '/Base.php' );
require_once( __DIR__ . '/Chat.php' );

class Chats extends Base {
  
  public $_type = 'SQLite';
  public $_table = null;
  public $_db = null;
  
  public function __construct() {
    try {
      $this->_table = strtolower( get_class( $this ) );
      // file or db?
      if( SQLITE_TYPE == 'FILE' ) {
        // is file?
        // is writeable?
        require_once( __DIR__ . '/Database.php' );
        $this->_db = new Database( $this->_type );
        if( ! is_file( SQLITE_FILE ) ) {
  				$string  = "File " . SQLITE_FILE . " does not exists, please run the following commands in you tty terminal.<br /><br />";
          $string .= "1. create the Database by:<br />";
          $string .= "sudo sqlite3 " . dirname( $dbfile ). "<br /><br />";
          $string .= "2. in the opened sqlite session enter the following sql statement (replace <TABLENAME> by your table!) and hit enter:";
          $string .= "CREATE TABLE " . $this->_table . " ( 'id' INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, 'name' TEXT NULL, 'email' TEXT NULL );";
          throw new Exception( $string );
        }
        if( $this->_type === 'SQLite' && SQLITE_TYPE === 'FILE' && ! is_writeable( SQLITE_FILE ) ) {
          $serverusername = posix_getpwuid(posix_geteuid());
          throw new Exception( "SQLite file not writeable by webserver user, please add write permissions to file and Folder! <br />sudo chown -R " . $serverusername['name'] . " " . dirname( SQLITE_FILE ). "<br />" );
        }
        
        // check Database connection
        if( ! $this->_db->connection() ) {
        	if ( SQLITE_TYPE === 'MEMORY' ) {
        		throw new Exception( "SQLite type: <strong>" . SQLITE_TYPE . "</strong> is not full implemented. <br />See <a href='https://www.sqlite.org/inmemorydb.html'>https://www.sqlite.org/inmemorydb.html</a> for example. <br /><br />No Database connection available, abort script. <br />" );
        	}
        }
        // does table exists and contain data?
        $query = "SELECT count(*) as sum FROM sqlite_master WHERE type='table' AND name='" . $this->_table . "';";
        $this->_db->query( $query );
        $this->_db->execute();
        $result = $this->_db->resultset();
        if( $result[0]['sum'] == "0" ) {
          // table does not exists
          if( ! $this->createDB() ) {
            throw new Exception( 'Unable to create Table ' . $this->_table );
          }
        }
        
      }
      
    } catch (Exception $e) {
      echo "<pre>";
      print_r( $e->getMessage() );
      echo "</pre>";
    }
    
  }
  
  public function dropDB() {
    $result = null;
    try {
      $query = "DROP TABLE IF EXISTS $this->_table";
      $this->_db->query( $query );
      $result = $this->_db->execute();
    } catch (Exception $e) {
      echo "<pre>";
      print_r( $e->getMessage() );
      echo "</pre>";
    }
    return $result;
  }

  public function createDB() {
    $result = null;
    try {
      $this->dropDB();
      $query = "CREATE TABLE $this->_table ( 
        'id' INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
        'name' TEXT NULL,
        'topic' TEXT NULL,
        'open' INTEGER NULL,
        'created' TEXT NULL,
        'updated' TEXT NULL
      )";
      $this->_db->query( $query );
      $result = $this->_db->execute();
      if( $result ) {
        // insert main chat room 0
        $query = "INSERT INTO " . $this->_table . " VALUES( 0, 'main', 'Main Chatroom', 1, '" . Base::date() . "', '' );";
        $this->_db->query( $query );
        $result = $this->_db->execute();
        if( ! $result ) {
          throw new Exception( 'Failed to insert Main Chatroom into Database!' );
        }
      }
      // make sure chats DB is also created
      $chat = new Chat();
      return true;
    } catch (Exception $e) {
      echo "<pre>";
      print_r( $e->getMessage() );
      echo "</pre>";
    } 
    return false;
  }
  
  public function createChat( $name = null, $topic = null, $open = null ) {
    if( $name === null ) return false;
    // allready a chat ?
    $result = $this->getChatByName( $name );
    if( $result ) {
      if( $result[0]['name'] == $name ) {
        return 'Chatroom with name "' . $name . '" already eyists!';
      }
    }
    $id = $this->getNextId();
    $topic = $topic === null ? '' : $topic;
    $open = $open === null ? 0 : $open;
    $created = Base::date();
    $updated = '';
    $query = "INSERT INTO " . $this->_table . " VALUES ( ".$id.", '".$name."', '".$topic."', ".$open.", '".$created."', '".$updated."' );";
    $this->_db->query( $query );
    $result = $this->_db->execute();
    if( $result ) {
      // create default entry for each Chatroom
      $chat = new Chat();
      $uid = 0;
      $text = DEFAULTXT . " $name";
      $create = $chat->createEntry( $id, $uid, $text );
      if( $create ) {
        return true;
      }
    }
    return false;
  }
  
  public function getChatById( $id = null ) {
    if( $id === null ) return false;
    $query = "SELECT * FROM " . $this->_table . " WHERE id = " . $id;
    $this->_db->query( $query );
    $result = $this->_db->execute();
    return $this->_db->resultset();
  }
  
  public function getChatByName( $name = null ) {
    if( $name === null ) return false;
    $query = "SELECT * FROM " . $this->_table . " WHERE name = '" . $name . "';";
    $this->_db->query( $query );
    $result = $this->_db->execute();
    return $this->_db->resultset();
  }

  public function updateChat( $id = null, $name = null, $topic = null, $open = null ) {
    if( $id === null ) return false;
    try {
      $result = $this->getChatByName( $name );
      if( $result ) {
        if( $result[0]['name'] == $name && $result[0]['id'] != $id  ) {
          return 'Chatroom with name "' . $name . '" already eyists!';
        }
      }
      $result = false;
      // get old data
      $query = "SELECT * FROM " . $this->_table . " WHERE id = " . $id . ";";
      $this->_db->query( $query );
      if( $this->_db->execute() ) {
        $result = $this->_db->resultset();
        $name = $name === null ? $result[0]['name'] : $name;
        $topic = $topic === null ? $result[0]['topic'] : $topic;
        $open = $open === null ? $result[0]['open'] : $open;
        $created = $result[0]['created'];
        $updated = Base::date();
      }
      $query = "UPDATE " . $this->_table . " SET name = '".$name."', topic = '".$topic."', open = ".$open.", created = '".$created."', updated = '".$updated."' WHERE id = " . $id;
      $this->_db->query( $query );
      $result = $this->_db->execute();
      if( $result ) {
        return true;
      }
    } catch (Exception $e) {
      return $e-getMessage();
    }
    return false;
  }

  public function deleteChat( $id = null ) {
    if( $id === null || $id == "0" ) return false; // dont delete the default chat
    // delete all entrie from chat table
    $chat = new Chat();
    $delete = $chat->deleteChatById( $id );
    // if( $delete ) {
      $query = "DELETE FROM " . $this->_table . " WHERE id = " . $id;
      $this->_db->query( $query );
      if( $this->_db->execute() ) {
        return true;
      }
    // } else {
    //   return $delete;
    // }
    return false;
  }

  public function isChats( $id ) {
    $chat = new Chat();
    $entries = $chat->hasEntries( $id );
    if( $entries ) {
      return true;
    } else {
      $query = "SELECT * FROM " . $this->_table . " WHERE id = " . $id;
      $this->_db->query( $query );
      $this->_db->execute();
      $result = $this->_db->resultset();
      if( isset( $result[0] ) ) {
        return true;
      }
    }
    return false;
  }

  public function listChats() {
    $query = "SELECT * FROM " . $this->_table;
    $this->_db->query( $query );
    $result = $this->_db->execute();
    return $this->_db->resultset();
  }

  public function getNextId() {
    $query = "SELECT max(id) as id FROM " . $this->_table;
    $this->_db->query( $query );
    $this->_db->execute();
    $result = $this->_db->resultset();
    return $result[0]['id'] +1;
  }

  public function entriesCount() {
    $query = "SELECT max(id) as id FROM " . $this->_table;
    $this->_db->query( $query );
    $this->_db->execute();
    $result = $this->_db->resultset();
    return $result[0]['id'];
  }

}

?>