<?php

require_once( __DIR__ . '/Base.php' );

class Session extends Base {
  
  private $_id = null; // user session id
  private $_users = null;
  private $_time = (86400 * 30); // 86400 = 1 Day
  private $_ip = null;

  public function __construct( $login = false ) {
    
    // start session and set session id
    $this->_id = session_id();
    if( $this->_id == null ) {
      session_start();
      $this->_id = session_id();
    }

    require_once( __DIR__ . '/../config.php' );
    require_once( __DIR__ . '/Users.php' );
    $this->_users = new Users();
    $this->_ip = Base::getIp();
    
    // banned?
    if( $this->_users->isBanned() ) {
      header( 'Location: Banned.php' );
      exit;
    }

    // is user already logged in? 
    $phpkey = $this->readSession( 'PHPKEY' );
    $id = $this->readSession( 'id' );
    
    if( $phpkey === null ) {
      // user is not logged in, redirect to login if not on Login Page
      if( $login === false && OPENAPP === false ) {
        header( 'Location: Login.php' );
        exit;
      }
    }

    if( $phpkey != null ) {
      $hashed = hash( 'sha256', SECRET . $this->_id );
      if( $phpkey != $hashed ) {
        // invalid user, something strange?
        if( OPENAPP === false ) {
          header( 'Location: Login.php' );
          exit;
        }
      }
    }

    if( ! $login ) { // not on login page
      if( $this->readSession( 'LogedIn' === null ) || $this->readSession( 'LogedIn' ) != 1 ) {
      //if( isset( $_COOKIE['PHPSESSID'] ) && $_COOKIE['PHPSESSID'] !== null  ) {
        $anon = $this->_users->finByIp( $this->_ip );
        if( isset( $anon[0]['sid'] ) ) {
          // user whith same ip found, compare sid's
          if( $anon[0]['sid'] == $this->_id ) {
            // same sid's
            // $this->writeSession( 'PHPKEY', $hashed );
            // $this->writeSession( 'LogedIn', 0 );
            // $this->writeSession( 'id', $anon[0]['id'] );
            $this->writeSession( 'user', $anon[0]['name'] );
            $this->writeSession( 'anon', 0 );
          } else {
            // different sid's but known user
            $this->writeSession( 'user', $this->_ip );
            $this->writeSession( 'anon', 0 );
          }
          $this->writeSession( 'id', $anon[0]['id'] );
        } else {
          // create new anon
          $anon = $this->_users->createAnonUser( $this->_id );
          // $this->writeSession( 'PHPKEY', $hashed );
          // $this->writeSession( 'LogedIn', 0 );
          $this->writeSession( 'id', $anon[0]['id'] );
          $this->writeSession( 'user', $anon[0]['name'] );
          $this->writeSession( 'anon', 0 );
        }
        // to all
        $hashed = hash( 'sha256', SECRET . $this->_id );
        $this->writeSession( 'PHPKEY', $hashed );
        $this->writeSession( 'LogedIn', 0 );
        //$this->writeSession( 'anon', 1 );
      }
    } else {
      // logged in user 
      
    }
    
  } // end __construct

  public function getRole( $userid ) {
    if( $userid != null ) {
      $result = $this->_users->readUser( $userid );
      if( ! empty( $result ) ) {
        return $result[0]['role'];
      }
    }
    return false;
  }

  public function isLoggedIn() {
    return $this->_users->isLoggedIn();
  }

  public function getSessionId() {
    return $this->_id;
  }

  public function readSession( $key = null ) {
    if( $key === null ) {
      return $_SESSION;
    } else if( isset( $_SESSION[ $key ] ) && $_SESSION[ $key ] != null && $_SESSION[ $key ] != "" ) {
      return $_SESSION[ $key ];
    }
		return false;
  }

  public function writeSession( $key = null, $value = null ) {
    if( $key === null || $value === null ) return false;
    $_SESSION[ $key ] = $value;
  }

  public function readCookie( $key = null ) {
    if( $key === null ) {
      return $_COOKIE;
    } else if( isset( $_COOKIE[ $key ] ) && $_COOKIE[ $key ] != null && $_COOKIE[ $key ] != "" ) {
      return $_COOKIE[ $key ];
    }
      return false;
  }

  public function writeCookie( $key = null, $value = null ) {
    if( $key === null || $value === null ) return false;
    setcookie( $key, $value, time() + $this->_time, "/" );
  }

}

?>