<?php

require_once( __DIR__ . '/../config.php' );
require_once( __DIR__ . '/Base.php' );
// require_once( __DIR__ . '/Chat.php' );

class Token extends Base {
  
  public $_type = 'SQLite'; // Todo, in all classes should this come from config
  public $_table = null;
  public $_db = null;
  
  public function __construct() {
    try {
      $this->_table = strtolower( get_class( $this ) );
      // file or db?
      if( SQLITE_TYPE == 'FILE' ) {
        // is file?
        // is writeable?
        require_once( __DIR__ . '/Database.php' );
        $this->_db = new Database( $this->_type );
        if( ! is_file( SQLITE_FILE ) ) {
  				$string  = "File " . SQLITE_FILE . " does not exists, please run the following commands in you tty terminal.<br /><br />";
          $string .= "1. create the Database by:<br />";
          $string .= "sudo sqlite3 " . dirname( $dbfile ). "<br /><br />";
          $string .= "2. in the opened sqlite session enter the following sql statement (replace <TABLENAME> by your table!) and hit enter:";
          $string .= "CREATE TABLE " . $this->_table . " ( 'id' INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, 'name' TEXT NULL, 'email' TEXT NULL );";
          throw new Exception( $string );
        }
        if( $this->_type === 'SQLite' && SQLITE_TYPE === 'FILE' && ! is_writeable( SQLITE_FILE ) ) {
          $serverusername = posix_getpwuid(posix_geteuid());
          throw new Exception( "SQLite file not writeable by webserver user, please add write permissions to file and Folder! <br />sudo chown -R " . $serverusername['name'] . " " . dirname( SQLITE_FILE ). "<br />" );
        }
        
        // check Database connection
        if( ! $this->_db->connection() ) {
        	if ( SQLITE_TYPE === 'MEMORY' ) {
        		throw new Exception( "SQLite type: <strong>" . SQLITE_TYPE . "</strong> is not full implemented. <br />See <a href='https://www.sqlite.org/inmemorydb.html'>https://www.sqlite.org/inmemorydb.html</a> for example. <br /><br />No Database connection available, abort script. <br />" );
        	}
        }
        // does table exists and contain data?
        $query = "SELECT count(*) as sum FROM sqlite_master WHERE type='table' AND name='" . $this->_table . "';";
        $this->_db->query( $query );
        $this->_db->execute();
        $result = $this->_db->resultset();
        if( $result[0]['sum'] == "0" ) {
          // table does not exists
          if( ! $this->createDB() ) {
            throw new Exception( 'Unable to create Table ' . $this->_table );
          }
        }
        
      } // end Type SQLite File
      
    } catch (Exception $e) {
      echo "<pre>";
      print_r( $e->getMessage() );
      echo "</pre>";
    }
    
  }
  
  public function dropDB() {
    $result = null;
    try {
      $query = "DROP TABLE IF EXISTS $this->_table";
      $this->_db->query( $query );
      $result = $this->_db->execute();
    } catch (Exception $e) {
      echo "<pre>";
      print_r( $e->getMessage() );
      echo "</pre>";
    }
    return $result;
  }

  public function createDB() {
    $result = null;
    try {
      $this->dropDB();
      $query = "CREATE TABLE $this->_table ( 
        'id' INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
        'user_id' INTEGER NOT NULL, 
        'name' TEXT NULL,
        'loginname' TEXT NULL,
        'password' TEXT NULL,
        'comment' TEXT NULL,
        'created' TEXT NULL,
        'updated' TEXT NULL, 
        FOREIGN KEY(user_id) REFERENCES users(id)
      )";
      $this->_db->query( $query );
      $result = $this->_db->execute();
      if( $result ) {
        // insert main chat room 0
        $query = "INSERT INTO " . $this->_table . " VALUES( 0, 0, 'Site Token', '".Base::genToken( 8, 2 )."', '".Base::genToken( 16, 2 )."', 'Initial Page Token', '" . Base::date() . "', '' );";
        $this->_db->query( $query );
        $result = $this->_db->execute();
        if( ! $result ) {
          throw new Exception( 'Failed to insert Main Token into Database!' );
        }
      }
      return true;
    } catch (Exception $e) {
      // echo "<pre>";
      // print_r( $e->getMessage() );
      // echo "</pre>";
      return $e->getMessage();
    } 
    return false;
  }
  
  public function createEntry( $user_id = null, $name = null, $loginname = null, $password = null, $comment = null ) {
    if( $user_id === null ) return false;
    // has user allready a token?
    $result = $this->getEntryByUserId( $user_id );
    if( $result ) {
      if( isset( $result[0]['user_id'] ) && $result[0]['user_id'] == $user_id ) {
        return 'User "' . $user_id . '" has already a token!';
      }
    }
    $id = $this->getNextId();
    $name = $name === null ? 'User Token' : $name;
    $loginname = $loginname === null ? Base::genToken( 8, 2 ) : $loginname; // generate if nothin is given
    $password = $password === null ? Base::genToken( 16, 2 ) : $password;    // generate if nothin is given
    $comment = $comment === null ? '' : $comment;
    $created = Base::date();
    $updated = '';
    $query = "INSERT INTO " . $this->_table . " VALUES ( ".$id.", ".$user_id.", '".$name."', '".$loginname."', '".$password."', '".$comment."', '".$created."', '".$updated."' );";
    $this->_db->query( $query );
    $result = $this->_db->execute();
    if( $result ) {
      // create default entry for each Chatroom
      $chat = new Chat();
      $uid = 0;
      $text = DEFAULTXT . " $name";
      $create = $chat->createEntry( $id, $uid, $text );
      if( $create ) {
        return true;
      }
    }
    return false;
  }
  
  public function getEntryById( $id = null ) {
    if( $id === null ) return false;
    $query = "SELECT * FROM " . $this->_table . " WHERE id = " . $id;
    $this->_db->query( $query );
    $result = $this->_db->execute();
    return $this->_db->resultset();
  }
  
  public function getEntryByName( $name = null ) {
    if( $name === null ) return false;
    $query = "SELECT * FROM " . $this->_table . " WHERE name like '%" . $name . "%';";
    $this->_db->query( $query );
    $result = $this->_db->execute();
    return $this->_db->resultset();
  }

  public function updateEntry( $id = null, $user_ui = null, $name = null, $loginname = null, $password = null, $comment = null ) {
    if( $id === null ) return false;
    try {
      // get old data
      $query = "SELECT * FROM " . $this->_table . " WHERE id = " . $id . ";";
      $this->_db->query( $query );
      if( $this->_db->execute() ) {
        $result = $this->_db->resultset();
        $user_id = $user_id === null ? $result[0]['user_id'] : $user_id;
        $name = $name === null ? $result[0]['name'] : $name;
        $loginname = $loginname === null ? $result[0]['loginname'] : $loginname; // generate if nothin is given
        $password = $password === null ? $result[0]['password'] : $password;    // generate if nothin is given
        $comment = $comment === null ? $result[0]['comment'] : $comment;
        $created = $result[0]['created'];
        $updated = Base::date();
      }
      $query = "UPDATE " . $this->_table . " SET user_id = ".$user_id.", name = '".$name."', loginname = '".$loginname."', password = '".$password."', comment = '".$comment."', created = '".$created."', updated = '".$updated."' WHERE id = " . $id;
      $this->_db->query( $query );
      $result = $this->_db->execute();
      if( $result ) {
        return true;
      }
    } catch (Exception $e) {
      return $e-getMessage();
    }
    return false;
  }

  public function deleteEntry( $id = null ) {
    if( $id === null || $id == 0 ) return false; // dont delete the default token for the page
    $query = "DELETE FROM " . $this->_table . " WHERE id = " . $id;
    $this->_db->query( $query );
    if( $this->_db->execute() ) {
      return true;
    }
    return false;
  }

  public function listEntries() {
    $query = "SELECT * FROM " . $this->_table;
    $this->_db->query( $query );
    $result = $this->_db->execute();
    return $this->_db->resultset();
  }

  public function getEntryByUser( $user_id = null ) {
    if( $user_id === null ) return false;
    $query = "SELECT * FROM " . $this->_table . " WHERE user_id = " . $user_id;
    $this->_db->query( $query );
    $result = $this->_db->execute();
    return $this->_db->resultset();
  }

  public function getNextId() {
    $query = "SELECT max(id) as id FROM " . $this->_table;
    $this->_db->query( $query );
    $this->_db->execute();
    $result = $this->_db->resultset();
    return $result[0]['id'] +1;
  }

  public function countEntries() {
    $query = "SELECT max(id) as id FROM " . $this->_table;
    $this->_db->query( $query );
    $this->_db->execute();
    $result = $this->_db->resultset();
    return $result[0]['id'];
  }

}

?>