<?php

require_once( __DIR__ . '/Base.php' );

class Users extends Base {
  
  public $_type = 'SQLite';
  public $_table = null;
  public $_db = null;
  public $_roles = array(
    '0'   => 'Sys Admin',
    '10'  => 'Admin',
    '20'  => 'Redacteur',
    '30'  => 'Author',
    '40'  => 'Registred Viewer',
    '50'  => 'Viewer'
  );
  
  public function __construct() {
    try {
      $this->_table = strtolower( get_class( $this ) );
      require_once( __DIR__ . '/../config.php' );
      require_once( __DIR__ . '/Database.php' );
      $this->_db = new Database( $this->_type );
      // check SQLite Database file (pathcheck is in the class)
      if( ! is_file( SQLITE_FILE ) ) {
				$string  = "File " . SQLITE_FILE . " does not exists, please run the following commands in you tty terminal.<br /><br />";
        $string .= "1. create the Database by:<br />";
        $string .= "sudo sqlite3 " . dirname( $dbfile ). "<br /><br />";
        $string .= "2. in the opened sqlite session enter the following sql statement (replace <TABLENAME> by your table!) and hit enter:";
        $string .= "CREATE TABLE " . $this->_table . " ( 'id' INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, 'name' TEXT NULL, 'email' TEXT NULL );";
        throw new Exception( $string );
      }
      if( $this->_type === 'SQLite' && SQLITE_TYPE === 'FILE' && ! is_writeable( SQLITE_FILE ) ) {
        $serverusername = posix_getpwuid(posix_geteuid());
        throw new Exception( "SQLite file not writeable by webserver user, please add write permissions to file and Folder! <br />sudo chown -R " . $serverusername['name'] . " " . dirname( SQLITE_FILE ). "<br />" );
      }
      // check Database connection
      if( ! $this->_db->connection() ) {
      	if ( SQLITE_TYPE === 'MEMORY' ) {
      		throw new Exception( "SQLite type: <strong>" . SQLITE_TYPE . "</strong> is not full implemented. <br />See <a href='https://www.sqlite.org/inmemorydb.html'>https://www.sqlite.org/inmemorydb.html</a> for example. <br /><br />No Database connection available, abort script. <br />" );
      	}
      }
      // does table exists and contain data?
      $query = "SELECT count(*) as sum FROM sqlite_master WHERE type='table' AND name='" . $this->_table . "';";
      $this->_db->query( $query );
      $this->_db->execute();
      $result = $this->_db->resultset();
      if( $result[0]['sum'] == "0" ) {
        // table does not exists
        $this->createDB();
      }
    } catch( Exception $e ) {
      echo "<pre>";
      print_r( $e->getMessage() );
      echo "</pre>";
    }
    
  }
  
  public function dropDB() {
    $query = "DROP TABLE IF EXISTS $this->_table";
    $this->_db->query( $query );
    return $this->_db->execute();
  }

  public function createDB() {
    try {
      $this->dropDB();
      $query = "CREATE TABLE $this->_table ( 
        'id' INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, 
        'name' TEXT NULL, 
        'password' TEXT NULL, 
        'email' TEXT NULL, 
        'notify' INTEGER NOT NULL, 
        'role' INTEGER NOT NULL, 
        'sid' TEXT NULL, 
        'banned' INTEGER NULL, 
        'ipAddr' TEXT NULL, 
        'macAddr' TEXT NULL, 
        'host' TEXT NULL, 
        'uagent' TEXT NULL, 
        'created' TEXT NULL, 
        'updated' TEXT NULL 
      );";
      $this->_db->query( $query );
      $result = $this->_db->execute();
      if( $result ) {
        $hashed = hash( 'sha256', SECRET . DEFAULTPASS );
        $query = "INSERT INTO " . $this->_table . " VALUES( 0, '" . DEFAULTUSER . "', '" . $hashed . "', 'noname@nomail.com', 1, 0, '', 0, '', '', '', '', '" . Base::date() . "', '' );";
        $this->_db->query( $query );
        $result = $this->_db->execute();
      }
    } catch (Exception $e) {
      echo "<pre>";
      print_r( $e->getMessage() );
      echo "</pre>";
    }
    return $result;
  }
  
  public function deleteUser( $id = null ) {
    if( $id === null || $id == 0 ) return false; // never delete the main admin
    $user = $this->readUser( $id ); // read the userdata
    if( isset( $user[0] ) ) {
      $query = "DELETE FROM " . $this->_table . " WHERE id = " . $id;
      $this->_db->query( $query );
      if( $this->_db->execute() ) {
        // logout the deleted user his his sessions!
        $logout = $this->unsetSessionById( $user[0]['sid'] );
        return true;
      }
    }
    return false;
  }

  public function updateUser( $id = null, $name = null, $password = null, $email = null, $notify = null, $role = null, $sid = null, $banned = null, $ipAddr = null, $macAddr = null, $host = null, $uagent = null ) {
    if( $id === null ) return false;
    try {
      // get old data
      $query = "SELECT * FROM " . $this->_table . " WHERE id = " . $id . ";";
      $this->_db->query( $query );
      if( $this->_db->execute() ) {
        $result = $this->_db->resultset();
        $name = $name === null ? $result[0]['name'] : $name;
        $password = $password === null ? $result[0]['password'] : $password;
        $email = $email === null ? $result[0]['email'] : $email;
        $notify = $notify === null ? (int) $result[0]['notify'] : (int) $notify;
        $role = $role === null ? $result[0]['role'] : $role;
        $sid = $sid === null ? $result[0]['sid'] : $sid;
        $banned = $banned === null ? $result[0]['banned'] : $banned;
        $ipAddr = $ipAddr === null ? $result[0]['ipAddr'] : $ipAddr;
        $macAddr = $macAddr === null ? $result[0]['macAddr'] : $macAddr;
        $host = $host === null ? $result[0]['host'] : $host;
        $uagent = $uagent === null ? $result[0]['uagent'] : $uagent;
        $created = $result[0]['created'];
        $updated = Base::date();
      }
      //$query = "UPDATE " . $this->_table . " SET sid = '".$sid."', ipAddr = '".$ip."', macAddr = '".$mac."' WHERE id = ".$id.";";
      $query = "UPDATE " . $this->_table . " SET name = '".$name."', password = '".$password."', email = '".$email."', notify = ".$notify.", role = ".$role.", sid = '".$sid."', banned = ".$banned.", ipAddr = '".$ipAddr."', macAddr = '".$macAddr."', host = '".$host."', uagent = '".$uagent."', created = '".$created."', updated = '".$updated."' WHERE id = " . $id;
      $this->_db->query( $query );
      $result = $this->_db->execute();
      if( $result ) {
        return true;
      }
      return false;
    } catch (Exception $e) {
      return $e-getMessage();
    }
  }

  public function createUser( $name = null, $password = null, $email = null, $notify = null, $role = null ) {
    if( $name === null || $password === null || $role === null ) return false;
    if( $notify === null ) $notify = 1;
    // get next id
    //$id = $this->_db->rowCount( $this->_table );
    $query = "SELECT max(id) as id FROM " . $this->_table;
    $this->_db->query( $query );
    $this->_db->execute();
    $result = $this->_db->resultset();
    $id = $result[0]['id'] +1;
    $hashed = hash( 'sha256', SECRET . $password );
    $query = "INSERT INTO " . $this->_table . " VALUES( ".$id.", '".$name."', '".$hashed."', '".$email."', ".$notify.", ".$role.", '', 0, '', '', '', '', '" . Base::date() . "', '' );";
    $this->_db->query( $query );
    return $result = $this->_db->execute();
  }
  
  public function createAnonUser( $sid = null ) {
    $query = "SELECT max(id) as id FROM " . $this->_table; // get the next id
    $this->_db->query( $query );
    $this->_db->execute();
    $result = $this->_db->resultset();
    $id = $result[0]['id'] +1;
    $role = 50;
    $ip = Base::getIp();
    $host = gethostbyaddr( $ip );
    $uagent = $_SERVER['HTTP_USER_AGENT'];
    $name = $host;
    $mac = $this->getMac();
    $notify = 1;
    $query = "INSERT INTO " . $this->_table . " VALUES( ".$id.", '".$name."', '', '', ".$notify.", ".$role.", '" . $sid . "', 0, '" . $ip . "', '" . $mac . "', '" . $host . "', '".$uagent."', '" . Base::date() . "', '' );";
    $this->_db->query( $query );
    $result = $this->_db->execute();
    if( $result ) {
      $query = "SELECT * FROM " . $this->_table . " WHERE id = " . $id . ";";
      $this->_db->query( $query );
      $this->_db->execute();
      return $this->_db->resultset();
    }
    return false;
  }

  public function readUser( $id = null ) {
    if( $id === null ) return false;
    $query = "SELECT * FROM " . $this->_table . " WHERE id = " . $id . ";";
    $this->_db->query( $query );
    $result = $this->_db->execute();
    return $this->_db->resultset();
  }
  
  public function listUsers() {
    $query = "SELECT * FROM " . $this->_table;
    $this->_db->query( $query );
    $result = $this->_db->execute();
    return $this->_db->resultset();
  }
  
  public function registerUser( $name = null, $password = null, $email = null, $notify = null ) {
    if( $name === null || $password === null ) return false;
    if( $notify === null ) $notify = 1;
    // is the name taken?
    $query = "SELECT name FROM " . $this->_table . " WHERE name = '" . $name . "';"; // OR email = '".$email."'
    $this->_db->query( $query );
    $dbresult = $this->_db->execute();
    $result = $this->_db->resultset();
    if( isset( $result[0]['name'] ) && $result[0]['name'] != $name ) {
      // IP allready in use, 
        return 'Username ' . $name . ' allready in use!';
    }
    
    // do we have allready an user whith this ip?
    $ip = Base::getIp();
    $query = "SELECT id, sid, ipAddr FROM " . $this->_table . " WHERE ipAddr = '" . $ip . "';";
    $this->_db->query( $query );
    $dbresult = $this->_db->execute();
    $result = $this->_db->resultset();
    // ( isset( $result[0]['sid'] ) && $result[0]['sid'] != session_id() ) &&
    if( ( isset( $result[0]['ipAddr'] ) && $result[0]['ipAddr'] != $ip ) ) {
      // IP allready in use, 
        return 'IP allready in use by registred user!';
    }
    
    $id = $result[0]['id'];
    if( $id === "0" ) return false; // dont overwrite our admin user!
    $sid = session_id();
    $mac = $this->getMac();
    $host = gethostbyaddr( $ip );
    $uagent = $_SERVER['HTTP_USER_AGENT'];
    $role = 40;
    $hashed = hash( 'sha256', SECRET . $password );
    $query = "UPDATE " . $this->_table . " SET name = '".$name."', password = '".$hashed."', email = '".$email."', notify = ".$notify.", role = ".$role.",sid = '".$sid."', ipAddr = '".$ip."', macAddr = '".$mac."', host = '".$host."', uagent = '".$uagent."' WHERE id = " . $id . ";";
    $this->_db->query( $query );
    $result = $this->_db->execute();
    if( $result ) {
      $query = "SELECT * FROM " . $this->_table . " WHERE id = " . $id . ";";
      $this->_db->query( $query );
      $dbresult = $this->_db->execute();
      return $this->_db->resultset();
    }
    return false;
  }
  
  // public function isLoggedIn() {
  //   $sid = session_id();
  //   $ip = Base::getIp();
  //   try {
  //     $query = "SELECT id FROM " . $this->_table . " WHERE sid is '" . $sid . "' or ipAddr is '" . $ip . "';";
  //     $this->_db->query( $query );
  //     $this->_db->execute();
  //     $result = $this->_db->resultset();
  //
  //     if( isset( $_SESSION['id'] ) && $_SESSION['id'] != null && $_SESSION['id'] != "" ) {
  //       if( isset( $result[0]['id'] ) && $result[0]['id'] == $_SESSION['id'] ) {
  //         return true;
  //       }
  //     }
  //   } catch (Exception $e) {
  //     echo "<pre>";
  //     print_r( $e->getMessage() );
  //     echo "</pre>";
  //   }
  //   return false;
  // }

  public function loginUser( $name = null, $password = null ) {
    if( $name === null || $password === null ) return false;
    $dbpasswd = null;
    try {
      $query = "SELECT id, name, password, email FROM " . $this->_table . " WHERE name is '" . $name . "' or email is '" . $name . "';";
      $this->_db->query( $query );
      $this->_db->execute();
      $dbres = $this->_db->resultset();
      if( isset( $dbres[0]['password'] ) ) {
        $dbpasswd = $dbres[0]['password'];
      }
      //$hashed = hash( 'sha256', SECRET . $password );
      $hashed = hash( 'sha256', SECRET . $password );
      //$hashed = $password;
      if( $hashed === $dbpasswd ) {
        // update user data
        $id = $dbres[0]['id'];
        $sid = isset( $_COOKIE['PHPSESSID'] ) ? $_COOKIE['PHPSESSID'] : session_id();
        //$sid = session_regenerate_id(); // generate a new session id
        $ip = Base::getIp();
        $mac = $this->getMac();
        $host = gethostbyaddr( $ip );
        
        // // cleanup all other user whith this ip!
        // if( $id != 0 ) {
        //   $query = "DELETE FROM " . $this->_table . " WHERE ( ipAddr = '" . $ip . "' OR macAddr = '" . $mac . "' OR sid = '" . $sid . "' ) AND id IS NOT " . $id . ";";
        //   $this->_db->query( $query );
        //   $this->_db->execute();
        // }

        $query = "UPDATE " . $this->_table . " SET sid = '".$sid."', ipAddr = '".$ip."', macAddr = '".$mac."', host = '".$host."', uagent = '".$uagent."' WHERE id = ".$id.";";
        $this->_db->query( $query );
        $this->_db->execute();
        return $dbres;
      } else {
        // no matching passwords
        
      }
    } catch (Exception $e) {
      echo "<pre>";
      print_r( $e->getMessage() );
      echo "</pre>";
    }
    return false;
  }

  public function logoutUser( $id = null ) {
    if( $id === null ) return false;
    // cleanup db data sid
    if( ! is_numeric( $id ) ) return false;
    $query = "UPDATE " . $this->_table . " SET sid = '' WHERE id = " . $id . ";"; // , ipAddr = '', macAddr = ''
    $this->_db->query( $query );
    return $this->_db->execute();
  }

  public function finByIp() {
    $ip = Base::getIp();
    $query = "SELECT id, name, sid FROM " . $this->_table . " WHERE ipAddr = '" . $ip . "';";
    $this->_db->query( $query );
    $result = $this->_db->execute();
    return $this->_db->resultset();
  }
  
  public function ban( $id = null, $ban = true ) {
    if( $id === null ) return false;
    if( is_bool( $ban ) ) {
      $query = "UPDATE " . $this->_table . " SET banned = '". (int) $ban."' WHERE id = " . $id . ";";
      $this->_db->query( $query );
      return $this->_db->execute();
    } 
    return false;
  }
  
  public function isBanned() {
    $ip = Base::getIp();
    $query = "SELECT banned FROM " . $this->_table . " WHERE ipAddr = '" . $ip . "';";
    $this->_db->query( $query );
    $dbres = $this->_db->execute();
    $result = $this->_db->resultset();
    if( $dbres ) {
      if( isset( $result[0] ) && $result[0]['banned'] == 1 ) {
        return true;
      }
    }
    return false;
  }

  public function getRoles() {
    return $this->_roles;
  }
  
  public function getRoleNameById( $key = null ) {
    if( $key === null ) return false;
    if( isset( $this->_roles[ $key ] ) && $this->_roles[ $key ] != null && $this->_roles[ $key ] != "" ) {
      return $this->_roles[ $key ];
    }
    return $key; // if nothing found send the key back
  }
  
  public function isOnline( $id = null ) {
    if( $id === null ) return false;
    $query = "SELECT sid, password FROM " . $this->_table . " WHERE id = " . $id;
    $this->_db->query( $query );
    $dbresult = $this->_db->execute();
    $result = $this->_db->resultset();
    if( isset( $result[0] ) ) { // maybe user is deleted?
      $user = $result[0];
      if( $online = isset( $user['sid'] ) && $user['sid'] != null && $user['sid'] != "" && 
          isset( $user['password'] ) && $user['password'] != null && $user['password'] != "" ) {
        return true;
      }
    }
    return false;
  }

  public function unsetSessionById( $sid= null  ) {
    if( $sid === null ) return false;
    // 1. commit session if it's started.
    if( session_id() ) {
        session_commit();
    }
    // 2. store current session id
    session_start();
    $current_session_id = session_id();
    session_commit();
    // 3. hijack then destroy session specified.
    session_id( $sid );
    session_start();
    session_destroy();
    session_commit();
    // 4. restore current session id. If don't restore it, your current session will refer to the session you just destroyed!
    session_id( $current_session_id );
    session_start();
    session_commit();
  }

}

?>