<?php
// is user loged in? 
require_once( __DIR__ . '/config.php' );
require_once( __DIR__ . '/class/Session.php' );
require_once( __DIR__ . '/class/Chats.php' ); 
require_once( __DIR__ . '/class/Token.php' ); 

$session = new Session();
$Chats = new Chats();
$token = new Token();
$chatNumbers = $Chats->entriesCount(); // Amount of chats in the DB
$redirect = false;

// Redirect if only one chat is enabled
if( SINGLECHAT ) {
  if( ! isset( $_REQUEST['id'] ) || $_REQUEST['id'] != "0" ) {
    $redirect = 'Location: ./?show=1&id=0&poll=1';
  }
}

$chatId = null;
$msg = null;
$openArr = array( '1' => 'open', '0' => 'close' );

if( isset( $_REQUEST['id'] ) && $_REQUEST['id'] != null && $_REQUEST['id'] =! "" ) {
  $chatId = $_GET['id'];
  if( ! $Chats->isChats( $chatId ) ) { 
    $redirect = 'Location: ./';
  }
}

// delete user
if( isset( $_REQUEST['delete'] ) && $_REQUEST['delete'] != null && $_REQUEST['delete'] =! "" ) {
  // delete
  $result = false;
  if( $chatId !== null ) {
    $result = $Chats->deleteChat( $chatId );
  }
  if( $result ) {
    $redirect = 'Location: ./';
  } else {
    $msg = array( 'err' => 'Failed to delete Chat ' . $chatId );
  }
}

if( $redirect ) {
  header( $redirect );
  exit;
}

if( isset($_REQUEST['show'] ) && $_REQUEST['show'] != null && $_REQUEST['show'] =! "" ) {
  
  // show a chat
  
  $chats = $Chats->getChatById( $chatId );
  $token = $token->getEntryByName( 'Site Token' ); // token for javascript
  $output  = "<div style='float:right;'>";
  if( $session->readSession( 'LogedIn' ) == 1 && $session->getRole( $session->readSession( 'id' ) ) != null && $session->getRole( $session->readSession( 'id' ) ) <= 30 ) {
    if( ! SINGLECHAT ) $output .= "<a href='./?create=1'>Create</a> | ";
  }
  if( $session->readSession( 'LogedIn' ) == 1 ) {
    $output .= "<a href='./'>Overview</a>";
  } else {
    if( $chatNumbers != 0 ) {
      $output .= "<a href='./'>Overview</a>";
    }
  }
  //$output .= "<a href='./'>Overview</a>";
  $output .= "</div>";
  $output .= "<h2 class='pageheadline'><small><span class='glyphicon glyphicon-comment' aria-hidden='true'></span></small> ";
  $output .= $chats[0]['name'];
  $output .= $chats[0]['open'] == "1" ? " (open)" : " (closed)";
  $output .= "</h2>";
  $output .= '<script type="text/javascript">' . "\n";
  $output .= 'var cid = '.$chatId.';' . "\n";
  $notify = $session->readCookie( 'notify' ) != null ? $session->readCookie( 'notify' ) : 0; 
  $output .= 'var notify = ' . $notify . ';' . "\n";
  $output .= 'var token = "' . $token[0]['loginname'] . $token[0]['password'] . '";' . "\n"; // get the page token into our javascript
  $output .= '</script>' . "\n";
  $output .= '<div id="chatWindow" class="table-responsive col-span-12">';
  $output .= '<div id="chatWrap">';
  $output .= "<table id='chatTable' class='table'>";
  $output .= "</table>";
  $output .= '</div>';
  $output .= '</div>';
  $output .= "<br />";
  
  $output .= '<div class="form-inline">';
  $output .= '  <div class="form-group mb-2 username">';
  $output .= '    <label for="chatnick" class="sr-only">Username</label>';
  if( $session->readSession( 'user' ) !== null ) {
//    $output .= '<input id="chatnick" type="text" value="' . $session->readSession( 'user' ) . '" class="form-control" readonly disabled>&nbsp;';
    $output .= '    <input id="chatnick" type="text" readonly class="form-control-plaintext" value="' . $session->readSession( 'user' ) . '">';
  } else {
//    $output .= '<input id="chatnick" type="text" value="" class="form-control">&nbsp;'; // size="15" maxlength="15"
    $output .= '    <input id="chatnick" type="text" value="" class="form-control-plaintext">&nbsp;';
  }
  $output .= '  </div>';
  $output .= '  <div class="form-group mx-sm-3 mb-2">';
  $output .= '    <label for="chatmsg" class="sr-only">Message</label>';
  $output .= '    <input id="chatmsg" type="text" class="form-control" onkeyup="keyup(event.keyCode);">';
  $output .= '  </div>';
//  $output .= '  <input id="chatsend" type="button" value="Send" onclick="submit_msg();" class="btn btn-default btn-red"><br>';
  $output .= '  <button type="submit" id="chatsend" class="btn btn-primary mb-2" onclick="submit_msg();">Send</button>';
  $output .= '  </div>';
  $output .= '</div>';

} else if( isset($_REQUEST['create'] ) && $_REQUEST['create'] != null && $_REQUEST['create'] =! "" ) {
  // create a chatroom
  
  $name = null;
  $topic = null;
  $open = 1;
  $result = null;
  
  if( isset( $_REQUEST['submit'] ) ) {
    
    if( isset( $_REQUEST['name'] ) && $_REQUEST['name'] != null && $_REQUEST['name'] != "" ) {
      $name = $_REQUEST['name'];
    }
    if( isset( $_REQUEST['topic'] ) && $_REQUEST['topic'] != null && $_REQUEST['topic'] != "" ) {
      $topic = $_REQUEST['topic'];
    }
    if( isset( $_REQUEST['open'] ) && $_REQUEST['open'] != null && $_REQUEST['open'] != "" ) {
      $open = $_REQUEST['open'];
    }
    
    $result = $Chats->createChat( $name, $topic, $open );
    
    if( $result && gettype( $result ) != 'string' ) {
      header( 'Location: ./' );
      exit;
    } else {
      if( gettype( $result ) === 'string' ) {
        $msg = array( 'err' => $result );
      } else {
        $msg = array( 'err' => "Failed to create Chatroom" );
      }
    }
    
  } // end submit
  
  if( $msg === null || isset( $msg['err'] ) ) {
    $output  = "<div style='float:right;'>";
    if( $session->readSession( 'LogedIn' ) == 1 && $session->getRole( $session->readSession( 'id' ) ) != null && $session->getRole( $session->readSession( 'id' ) ) <= 30 ) {
      if( ! SINGLECHAT ) $output .= "<a href='?create=1'>Create</a> | ";
    }
    $output .= "<a href='./'>Overview</a>";
    $output .= "</div>";
    $output .= "<h2><small><span class='glyphicon glyphicon-comment' aria-hidden='true'></span></small> Create new Chatroom</h2>";
    $output .= "<div class='msg" . ( isset( $msg['err'] ) ? ' error' : '' ) . "'>" . $msg['err'] . "</div>";
    $output .= "<div class='col-sm-12'>";
    $output .= "<form action='?create=1&id=" . $chatId . "' method='post'>";
    $output .= " <formfield class='form-group'>";
    
    $output .= '    <div class="form-group">' . "\n";
    $output .= "      <label for='name'>Chatroom Name:</label><br />";
    $output .= '  		<div class="col-sm-4">' . "\n";
    $output .= "        <input type='text' name='name' id='name' value='".$name."' /><br /><br />";
    $output .= '      </div>' . "\n";
    $output .= '    </div>' . "\n";
    
    $output .= '    <div class="form-group">' . "\n";
    $output .= "      <label for='topic'>Chatroom Topic:</label><br />";
    $output .= '  		<div class="col-sm-4">' . "\n";
    $output .= "        <input type='text' name='topic' id='topic' value='".$topic."' /><br /><br />";
    $output .= '      </div>' . "\n";
    $output .= '    </div>' . "\n";

    $output .= '    <div class="form-group">' . "\n";
    $output .= "    <label for='open'>Openchat:</label><br />";
    $output .= '    <select name="open" id="open">';
    foreach( $openArr as $key => $openValue ) {
      $active = $open == $key ? ' selected="selected"' : '';
      $output .= "       <option value='" . $key . "'" . $active . ">" . $openValue . "</option>";
    }
    $output .= '    </select><br /><br />';
    $output .= '    </div>' . "\n";
    
    $output .= " </formfield>";
    
    $output .= '  <div class="form-group">' . "\n";
    $output .= '    <div class="col-sm-offset-2 col-sm-4">' . "\n";
    $output .= '      <button id="btnSave" type="submit" name="submit" class="btn btn-default btn-red">' . "\n";
    $output .= '        <span class="glyphicon glyphicon-saved"></span> Save' . "\n";
    $output .= '      </button>' . "\n";
    $output .= '    </div>' . "\n";
    $output .= '  </div>';
    
    $output .= "</form>";
    $output .= "</div>";
  } // end create form
  
} else if( isset( $_REQUEST['edit'] ) && $_REQUEST['edit'] != null && $_REQUEST['edit'] =! "" ) {
  // edit a chat
  
  $name = null;
  $topic = null;
  $open = null;
  $result = null;
  
  $chats = $Chats->getChatById( $chatId );
  
  if( $chats && $chats[0]['id'] == $chatId ) {
    $name = $chats[0]['name']; 
    $topic = $chats[0]['topic']; 
    $open = $chats[0]['open']; 
  }
  
  if( isset( $_REQUEST['submit'] ) ) {
    
    if( isset( $_REQUEST['name'] ) && $_REQUEST['name'] != null && $_REQUEST['name'] != "" ) {
      $newname = $_REQUEST['name'];
    }
    if( isset( $_REQUEST['topic'] ) && $_REQUEST['topic'] != null && $_REQUEST['topic'] != "" ) {
      $topic = $_REQUEST['topic'];
    }
    if( isset( $_REQUEST['open'] ) && $_REQUEST['open'] != null && $_REQUEST['open'] != "" ) {
      $open = $_REQUEST['open'];
    }
    
    $result = $Chats->updateChat( $chatId, $newname, $topic, $open );
    
    if( $result && gettype( $result ) != 'string' ) {
      header( 'Location: ./' );
      exit;
    } else {
      if( gettype( $result ) == 'string' ) {
        $msg = array( 'err' => $result );
      } else {
        $msg = array( 'err' => "Failed to edit Chatroom" );
      }
    }
    
  } // end submit
  
  if( $msg === null || isset( $msg['err'] ) ) {
    $output  = "<div style='float:right;'>";
    if( $session->readSession( 'LogedIn' ) == 1 && $session->getRole( $session->readSession( 'id' ) ) != null && $session->getRole( $session->readSession( 'id' ) ) <= 30 ) {
      if( ! SINGLECHAT ) $output .= "<a href='./?create=1'>Create</a> | ";
    }
    $output .= "<a href='./'>Overview</a>";
    $output .= "</div>";
    $output .= "<h2><small><span class='glyphicon glyphicon-comment' aria-hidden='true'></span></small> Edit chat " . $name . "</h2>";
    $output .= "<div class='msg" . ( isset( $msg['err'] ) ? ' error' : '' ) . "'>" . $msg['err'] . "</div>";
    $output .= "<div class='col-sm-12'>";
    $output .= "<form action='?edit=1&id=" . $chatId . "' method='post'>";
    $output .= " <formfield>";
    
    $output .= '    <div class="form-group">' . "\n";
    $output .= "      <label for='name'>Chatroom Name:</label><br />";
    $output .= '  		<div class="col-sm-4">' . "\n";
    $output .= "        <input type='text' name='name' id='name' value='".$name."' /><br /><br />";
    $output .= '      </div>' . "\n";
    $output .= '    </div>' . "\n";
    
    $output .= '    <div class="form-group">' . "\n";
    $output .= "      <label for='topic'>Chatroom Topic:</label><br />";
    $output .= '  		<div class="col-sm-4">' . "\n";
    $output .= "        <input type='text' name='topic' id='topic' value='".$topic."' /><br /><br />";
    $output .= '      </div>' . "\n";
    $output .= '    </div>' . "\n";
    
    $output .= "  <label for='open'>Openchat:</label><br />";
    $output .= '  <select name="open" id="open">';
    foreach( $openArr as $key => $openValue ) {
      $active = $open == $key ? ' selected="selected"' : '';
      $output .= "     <option value='" . $key . "'" . $active . ">" . $openValue . "</option>";
    }
    $output .= '  </select><br /><br />';
    
    $output .= " </formfield>";
    
    $output .= '  <div class="form-group">' . "\n";
    $output .= '    <div class="col-sm-offset-2 col-sm-4">' . "\n";
    $output .= '      <button id="btnSave" type="submit" name="submit" class="btn btn-default btn-red">' . "\n";
    $output .= '        <span class="glyphicon glyphicon-saved"></span> Save' . "\n";
    $output .= '      </button>' . "\n";
    $output .= '    </div>' . "\n";
    $output .= '  </div>';
    
    $output .= "</form>";
    $output .= "</div>";
  } // end edit form
  
} else {

  // default action, list all chats

  if( $chatNumbers == 1 && $session->readSession( 'LogedIn' ) != 1 ) {
    header( 'Location: ./?show=1&id='.$chatNumbers.'&poll=1' );
    exit;
  }

  $chats = $Chats->listChats();
  $output  = "<div style='float:right;'>";
  if( $session->readSession( 'LogedIn' ) == 1 && $session->getRole( $session->readSession( 'id' ) ) != null && $session->getRole( $session->readSession( 'id' ) ) <= 30 ) {
    if( ! SINGLECHAT ) $output .= "<a href='./?create=1'>Create</a> | ";
  }
  if( $session->readSession( 'LogedIn' ) == 1 ) {
    $output .= "<a href='./'>Overview</a>";
  } else {
    if( $chatNumbers != 0 ) {
      $output .= "<a href='./'>Overview</a>";
    }
  }
  
  $output .= "</div>";
  $output .= "<h2><small><span class='glyphicon glyphicon-comment' aria-hidden='true'></span></small> Chats Overview</h2>";
  $output .= "<div class='msg" . ( isset( $msg['err'] ) ? ' error' : '' ) . "'>" . $msg['err'] . "</div>";
  $output .= "<div class='col-span-12'>";
  $output .= "<table class='table'>";
  $output .= "<tr>";
  $output .= "<th>ID</th><th>name</th><th>open</th><th>created</th>";
  if( $session->readSession( 'LogedIn' ) == 1 && $session->getRole( $session->readSession( 'id' ) ) != null && $session->getRole( $session->readSession( 'id' ) ) <= 30 ) {
    $output .= "<th>Actions</th>";
  }
  $output .= "</tr>";
  foreach( $chats as $key => $chat ) {
    $output .= "<tr>";
    $output .= "  <td>".$key."</td>";
    $output .= "  <td><a href='?show=1&id=".$key."&poll=1'>".$chat['name']."</a></td>";
    $output .= "  <td>".$chat['open']."</td>";
    $output .= "  <td>".$chat['created']."</td>";
    if( $session->readSession( 'LogedIn' ) == 1 && $session->getRole( $session->readSession( 'id' ) ) != null && $session->getRole( $session->readSession( 'id' ) ) <= 30 ) {
      $output .= "  <td>";
      $output .= "    <a href='?edit=1&id=".$key."'>Edit</a> | ";
      $output .= "    <a href='?delete=1&id=".$key."' onclick=\"return confirm('Delete chat " . $chat['name'] . "?')\">Delete</a>";
      $output .= "  </td>";
    }
    $output .= "</tr>\n";
    if( SINGLECHAT ) break;
  }
  $output .= "</table>";
  $output .= '<input id="chatmsg" type="hidden" /> ';
  $output .= "</div>";
}

?>
<!DOCTYPE html>
<html lang="en">

<?php require_once( __DIR__ . '/tpl/head.php' ) ?>

<body>

<?php require_once( __DIR__ . '/tpl/header.php' ) ?>

<div class="container">

  <div class="maincont">

<?php

// print the output
echo $output;

?>

  </div>
  
</div>

<?php



// echo "<pre>";
// //print_r( Base::token( 'Test' ) );
// print_r( $token->getEntryByName( 'Site Token' ) );
// echo "</pre>";

// require_once( __DIR__ . '/class/Base.php' );
// echo "<pre>IP &nbsp;: ";
// print_r( Base::getIp() );
// echo "\nName: ";
// print_r( $session->readSession( 'user' ) );
// echo "\nCompare: ";
// print_r( (int) Base::getIp() == $session->readSession( 'user' ) );
// echo "</pre>";

  
?>

<?php require_once( __DIR__ . '/tpl/footer.php' ) ?>

</body>
</html>