<?php

require_once( __DIR__ . '/../class/Base.php' );
require_once( __DIR__ . '/../class/Chats.php' ); 

$path = "./";
$mask = "*";
$prefix = ".php";
$active = false;

// read all php files by glob
$files = glob( $path . $mask . $prefix);

// sort reverse 
rsort( $files );


// some default client data
$userId   = $session->readSession( 'id' );
$userId   = $userId === null ? '' : $userId;
$userName = $session->readSession( 'user' );
$userName = $userName === null ?  : $userName;
$userRole = $session->getRole( $userId );
$userRole = $userRole !== null ? $userRole : 50;
$userLoggedIn = $session->readSession( 'LogedIn' );
$userLoggedIn = $userLoggedIn !== null && $userLoggedIn == 1 ? true : false;
$userIp   = Base::getIp(); // todo get client ip finction

?>
<nav class="navbar navbar-expand-sm navbar-light bg-light">
  
<?php

$Chats = new Chats();
$chatNumbers = $Chats->entriesCount();

$dest = $chatNumbers == 0 ? './?show=1&id=' . $chatNumbers . '&poll=1': './'; // if only one chat, set destination of the button to th chatid

echo '<a class="navbar-brand" href="' . $dest . '"><img src="tpl/img/favicon.ico" alt="' . APPNAME . '" title="Main Page" height="26px" /></a>';

?>
  
  <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
    <span class="navbar-toggler-icon"></span>
  </button>

  <div class="collapse navbar-collapse" id="navbarSupportedContent">
    
    <ul class="navbar-nav mr-auto">

      <?php foreach( $files as $key => $value ) : ?>
<?php echo "\n";
          
          // get Filenames/Pagenames
          $name = ucfirst( str_replace( array( $path, '.php' ), array( '', '' ), $value ) );

          // exclude some default pages
          if( $name === 'Config' || $name === 'Banned' || $name === 'Api' || $name === 'Search' ) continue;

          // find the current active (name is same)
          $current = ucfirst( SCRIPTRAW );

          //
          // Static positionin Menu entries
          //

          if( $name === 'System' ) {
            if( $userLoggedIn && $userRole == 0 ) {
              $active = $name == $current ? ' active' : '';
              echo '      <li class="nav-item' . $active . '" title="Configure Application">' . "\n";
              echo '        <a class="nav-link" href="' . $value . '">' . $name . '</a>' . "\n";
              echo '      </li>' . "\n";
            }
            continue;
          }

          if( $name === 'Index' ) {
            $active = $name == $current || $current == '' ? ' active' : '';
            echo '      <li class="nav-item' . $active . '" title="Main chat page">' . "\n";
            echo '        <a class="nav-link" href="./">Chats</a>' . "\n";
            echo '      </li>' . "\n";
            continue;
          }

          if( $name === 'Users' ) {
            if( $userLoggedIn && $userRole <= 10 ) {
              $active = $name == $current ? ' active' : '';
              echo '      <li class="nav-item' . $active . '" title="Users Overview">' . "\n";
              echo '        <a class="nav-link" href="' . $value . '">' . $name . '</a>' . "\n";
              echo '      </li>' . "\n";
            }
            continue;
          }

          if( $name === 'Login' ) {
            $active = $name == $current ? ' active' : '';
            echo '      <li class="nav-item' . $active . '" title="Login user">' . "\n";
            if( $userLoggedIn ) {
              echo "        <a class='nav-link' href='" . $value . "?logout=1'>Logout</a>\n";
            } else {
              echo "        <a class='nav-link' href='" . $value . "'>Login</a>\n";
            }
            echo '      </li>' . "\n";
            continue;
          }

          // for all autogenerated Pages
          $active = $name == $current ? ' active' : '';

        ?>
        <li class="nav-item<?= $active ?>">
          <a class="nav-link" href="<?= $value ?>"><?= $name ?> </a>
        </li>
      <?php endforeach; ?>
      
      <!-- Static Page link, last position -->
      <li class="nav-item" title="Client Settup">
      <?php
        if( $userLoggedIn ) {
          echo '  <a class="nav-link" href="Users.php?edit=1&uid=' . $userId . '">';
          echo $userName;
          if( DEBUG ) { // show user role number
            echo ' - ' . (int) $userRole;
          }
          echo '</a>' . "\n";
        } else if( isset( $_GET['register'] ) === false ) {
          // non logged in Users and Not on register From
          if( $session->readSession( 'anon' ) !== "1" ) {
            // non anon users
            if( $userName != null && $userName != $userIp ) {
              // isset userName && userName is not the IP
              
            }
            echo '  <a class="nav-link" href="Login.php?register=1">register ' . $userName . '</a>' . "\n";
          }
        }
      ?>
      </li>

    </ul>

    <?php // search form?>
    <form action="Search.php" method="POST" class="navbar-form navbar-left">
      <div class="input-group">
        <input type="text" name="search" class="form-control" placeholder="Search in Chats">
        <span class="input-group-btn">
          <button type="submit" class="btn btn-default">Submit</button>
        </span>
      </div><!-- /input-group -->
    </form>
    
  </div><!-- /.navbar-collapse -->
  
</nav>