
// get parameters from url
const queryString = window.location.search;
const urlParams = new URLSearchParams(queryString);
var edit = urlParams.get('edit');
var cid = urlParams.get('id');
var polling = urlParams.get('poll');
var currentPage = window.location.pathname;
currentPage = currentPage.substring( currentPage.lastIndexOf( '/' ) + 1 );
currentPageRaw = currentPage.substring( 0, currentPage.lastIndexOf( '.php' ) );

// console.log(' href => ' + window.location.href);
// console.log(' host => ' + window.location.host);
// console.log(' hostname => ' + window.location.hostname);
// console.log(' port => ' + window.location.port);
// console.log(' protocol => ' + window.location.protocol);
// console.log(' pathname => ' + window.location.pathname);
// console.log(' hashpathname => ' + window.location.hash);
// console.log(' search=> ' + window.location.search);
// console.log( currentPage );

var init = true;
var notify = false;

/* Settings you might want to define */
var waittime=1000;


// var xmlhttp = false;
// var xmlhttp2 = false;

// if datestring s is today, show the time, else show the date
// some ideas about timezones in javascript: https://medium.com/@toastui/handling-time-zone-in-javascript-547e67aa842d
function dateFormat( s ) {
  var today = new Date();
  var timeOffset = today.getTimezoneOffset();
  timeOffset = parseInt( timeOffset ) / 60;
  var dateStr = s.substr( 0, 10 );
  var result = dateStr; // default time, show date
  var tHour = s.substr( 11, 2 );
  //tHour = parseInt( tHour ) + timeOffset; // depend on timezone!
  tHour = parseInt( tHour ) + 1;
  var tMinute = s.substr( 14, 2 )
  var tSecond = s.substr( 17, 2 );
  var timeStr = ( tHour < 10 ? '0' + tHour : tHour ) + ':' + tMinute + ':' + tSecond;
  //var timeStr = s.substr( 11, 8 );
  var tDay = today.getDate();
  var tMonth = today.getMonth() +1;
  var tYear = today.getFullYear();
  var dateStrNow = ( tYear < 10 ? '0' + tYear : tYear ) + '-' + ( tMonth < 10 ? '0' + tMonth : tMonth ) + '-' + ( tDay < 10 ? '0' + tDay : tDay );
  if( dateStrNow == dateStr ) {
    result = timeStr; // set to time if we are on the same day
  }
  return result;
}

function nameFormat( nameObject ) {
  // online Usersnames should be styleable by class online
  var result = nameObject.users_id;
  if( nameObject.online == 1 ) {
    result = '<span class="online">' + result + '</span>';
  }
  return result
}

function textFormat( s ) {
  var result = s;
  // https://www.urlencoder.org/
  result = result.replace( '%26', '&' );
  result = result.replace( '%3D', '=' );
  result = result.replace( '%5C', "\\" );
  result = result.replace( '%3A', ':' );
  result = result.replace( '%22', '"' );
  result = result.replace( '%25', '%' );
//  result = result.replace( '%2F', '/' );
  result = result.replace( '%3A', '\\' );
  // https://stackoverflow.com/a/36202408/5208166
  result = result.replace(/((http|https|ftp):\/\/[\w?=&.\/-;#~%-]+(?![\w\s?&.\/;#~%"=-]*>))/g,'<a href="$1" target="_blank">$1</a> '); // make urls clickable
  return result;
}

function buildEntry( item, index ) {
  var newName = nameFormat( item );
  var newTime = dateFormat( item.created );
  var newText = textFormat( item.text );
  var result = "<tr>";
  result += "<td <td class='cdate'>" + newTime + "</td>";
  result += "<td <td class='cname'>" + newName + "</td>";
  result += "<td <td class='ctext'>" + newText + "</td>"; // + ' <a type="button" href="?delete=1&id=' + item.id + '" class="close" aria-label="Close"><span aria-hidden="true">&times;</span></button>'
  result += "</tr>";
  return result;
}





/* Request for Reading the Chat Content */
function ajax_read( url, params ) {

  // params = encodeURI( params );
  params = JSON.parse('{"' + decodeURI(params.replace(/&/g, "\",\"").replace(/=/g,"\":\"")) + '"}');

  $.ajax({
    type: "POST",
    url: url,
    data: params,
    async: true
  })
  .success( function( erg ) {
    var response = erg;
    if( init && response != null ) {
      var result = '<table id="chatTable" class="">'; // class="table"
      for( i = 0; i < response.length; i++ ) {
        result += buildEntry( response[ i ], i );
      }
      result += '</table>';
      document.getElementById( "chatWrap" ).innerHTML = result;
      init = false;
      $('#chatWrap').animate({ scrollTop: $('#chatWrap').children().height() }, "fast"); // scroll chat down
    } else if( response ) {
      // apend all new elements
      for( i = 0; i < response.length; i++ ) {
        var table = document.getElementById( 'chatTable' );
        var tableBody = table.getElementsByTagName( 'tbody' );

        // if no table body is present
        if( tableBody[0] == undefined ) {
          var tableRows = 0;
        } else {
          var tableRows = tableBody[0].childElementCount;
        }

        var newName = nameFormat( response[i] );
        var newTime = dateFormat( response[i].created );
        var newText = textFormat( response[i].text );
        
        var newRow = table.insertRow( tableRows );
        var row0 = newRow.insertCell( 0 ); // created
        var row1 = newRow.insertCell( 1 ); // users_id
        var row2 = newRow.insertCell( 2 ); // text
        row0.innerHTML = newTime;
        row1.innerHTML = newName;
        row2.innerHTML = newText;
        
        // notification
        if( localStorage.getItem( 'notification-permissions' ) === 'granted' ) {
          // only if window dont has focus?
          if( ! document.hasFocus() ) {
            new Notification( response[i].users_id + ": " + response[i].text );
          }
          
        }
        $('#chatWrap').animate({ scrollTop: $('#chatWrap').children().height() }, "fast"); // scroll chat down
      }
    }
  })
  .fail( function( e, err ) {
  	console.log( err );
  });

  setTimeout( "ajax_read('api.php', 'c=" + cid + "&t=" + Math.floor( Date.now() / 1 ) + "&tk=" + token + "')", waittime ); // send next request

}

/* Request for Writing the Message */
function ajax_write( url, params ) {

  // params = encodeURI( params );
  
  // decode params
  // source idea: https://stackoverflow.com/a/8649003/5208166
  params = JSON.parse('{"' + decodeURI(params.replace(/&/g, "\",\"").replace(/=/g,"\":\"")) + '"}');

  $.ajax({
    type: "POST",
    url: url,
    data: params
  })
  .success( function( erg ) {
    // do something with the result?
    
  })
  .fail( function( e, err ) {
  	console.log( err );
  });
 
}

/* Submit the Message */
function submit_msg(){
  nick = document.getElementById( "chatnick" ).value;
  msg = document.getElementById( "chatmsg" ).value;

  if( nick == "" ) {
    check = prompt( "please enter username:" );
    if( check === null ) return 0;
    if( check == "" ) check = "anonymous";
    document.getElementById( "chatnick" ).value = check;
    nick = check;
  }

  // https://www.urlencoder.org/
  msg = msg.replace( '=', '%3D' );
  msg = msg.replace( '&', '%26' );
  msg = msg.replace( "\\", '%5C' );
  msg = msg.replace( ':', '%3A' );
  msg = msg.replace( '"', '%22' );
  msg = msg.replace( '%', '%25' );
//  msg = msg.replace( '/', '%2F' );
  console.log( msg );
  //msg = encodeURI( msg );
  document.getElementById( "chatmsg" ).value = ""; // empty inputfield
  //ajax_write( "x.php?c=" + cid + "&u=" + uid + "&t=" + msg );
  ajax_write( "api.php", "c=" + cid + "&u=" + uid + "&msg=" + msg + "&tk=" + token );
}


function getNotificationPermissions() {
  if( Notification.permissions === 'granted' ) {
    return localStorage.getItem( 'notification-permissions' );
  } else {
    return Notification.permissions;
  }
}

function notifyMe( input ) {

  // Let's check if the browser supports notifications
  if (!("Notification" in window)) {
    alert("This browser does not support desktop notification");
    return;
  }
  
  // source idea: 
  // - https://stackoverflow.com/a/28478605/5208166
  // - https://developer.mozilla.org/de/docs/Web/API/notification
  if( Notification.permissions === 'granted' ) {
    localStorage.setItem( 'notification-permissions', input.checked ? 'granted' : 'denied' ); // reset on local store
  } else if ( Notification.permissions === 'denied' ) {
    localStorage.setItem( 'notification-permissions', 'denied' ); // set denied
    input.checked = false;
  } else if( Notification.permissions === 'default' || Notification.permissions == null ) {
    Notification.requestPermission( function( choice ) {
      if( choice === 'granted' ) {
        localStorage.setItem( 'notification-permissions', input.checked ? 'granted' : 'denied' );
      } else {
        localStorage.setItem( 'notification-permissions', 'denied' );
        input.checked = false;
      }
    });
  }

}

function notifyBtn() {
  
  var notify = document.getElementById( "notify" );
  
  if( notify != null ) {
    if( localStorage.getItem( 'notification-permissions' ) === "granted" ) {
      notify.checked = true;
    } else {
      notify.checked = false;
    }
  }
}

/* document ready */
document.addEventListener("DOMContentLoaded", function( event ) {

  localStorage.setItem( 'notification-permissions', notify ? 'granted' : 'denied' );

  if( cid != undefined && polling != undefined ) {
    var chatwrap = document.getElementById( "chatWrap" );
    if( chatwrap != undefined ) {
      chatwrap.innerHTML = "loading...";
    }
  }

  // set focus to inputfields
  var chatmsg = document.getElementById( "chatmsg" );
  if( chatmsg != undefined ) {
    chatmsg.focus()
  }

  var username = document.getElementById( "name" );
  if( username != undefined ) {
    username.addEventListener("focus", function() { this.select(); }); // select all
    username.focus();
  } 

  if( currentPageRaw === '' || currentPage === 'index.php' ) {
    /* Show Loading Text */
    var chatwrap = document.getElementById( "chatWrap" );
    if( chatwrap != undefined ) {
      chatwrap.innerHTML = "loading...";
    }
    if( cid != undefined && polling != undefined ) {
      // init Polling (send only a channel id and no time)
      var intUpdate = setTimeout( "ajax_read( 'api.php', 'c=" + cid + "&tk=" + token + "')", 1000 );
    }
  } 

  if( currentPage === 'Users.php' && edit == 1  &&  document.getElementById( "notify" ) != null ) {
    notifyBtn();
  }
 
});

/* Check if Enter is pressed on Chatspage */
function keyup( arg1 ) {
  if( arg1 == 13 && polling == 1 && currentPageRaw === '' || currentPage === 'index.php' ) {
    submit_msg();
  }
}
