<?php

// includes
require_once( './Solaris/moon.php' );
require_once( './Solaris/MoonPhase.php' );

// default values
$lat 	= 52.2721095;
$long 	= 10.3878027;
$tz 	= "Europe/Berlin";
$result = null;

// Helper functions
// timezone validator
function isValidTimezoneId($timezoneId) {
	@$tz=timezone_open($timezoneId);
	return $tz!==FALSE;
}
// 
function calcLength($start, $end) {
	return date("H:i", strtotime("00:00") + strtotime($end) - strtotime($start));
}

// override default values by request data
if( isset( $_REQUEST['lat'] ) && is_numeric( $_REQUEST['lat'] ) ) {
	$lat = $_REQUEST['lat'];
}

if( isset( $_REQUEST['long'] ) && is_numeric( $_REQUEST['long'] ) ) {
	$long = $_REQUEST['long'];
}

if( isset( $_REQUEST['tz'] ) && $_REQUEST['tz'] ) {
	$tz = $_REQUEST['tz'];
}
date_default_timezone_set( $tz );
$tzoffset = substr( date("O", strtotime("now") ), 0, 3 );

// debug request
$proto   = isset($_SERVER['HTTPS']) && in_array($_SERVER['HTTPS'], ['on', 1]) ? 'https' : 'http';
$url = $proto . "://" . $_SERVER['HTTP_HOST'] .  $_SERVER['SCRIPT_NAME'] . "?lat=" . $lat . "&long=" . $long . "&tz=" . $tz;
$url = str_replace( "index.php", "", $url );

// sun info
$suninfo = date_sun_info( strtotime("now"), $lat, $long );
$result['sun']['astronomical_twilight_begin'] = date("H:i", $suninfo['astronomical_twilight_begin']);
$result['sun']['nautical_twilight_begin'] = date("H:i", $suninfo['nautical_twilight_begin']);
$result['sun']['civil_twilight_begin'] = date("H:i", $suninfo['civil_twilight_begin']);
$result['sun']['sunrise'] = date("H:i", $suninfo['sunrise']);
$result['sun']['zenith'] = date("H:i", $suninfo['transit'] );
$result['sun']['sunset'] = date("H:i", $suninfo['sunset']);
$result['sun']['civil_twilight_end'] = date("H:i", $suninfo['civil_twilight_end']);
$result['sun']['nautical_twilight_end'] = date("H:i", $suninfo['nautical_twilight_end']);
$result['sun']['astronomical_twilight_end'] = date("H:i", $suninfo['astronomical_twilight_end']);
$result['sun']['day'] = calcLength( $result['sun']['sunrise'], $result['sun']['sunset'] );
$result['sun']['daylight'] = calcLength( $result['sun']['civil_twilight_begin'], $result['sun']['civil_twilight_end'] );

// moon info
$mooninfo = Moon::calculateMoonTimes( date('m'), date('d'), date('Y'), $lat, $long );
$moon = new Solaris\MoonPhase();
$moonrise = date("H:i", $mooninfo->moonrise);
$moonset = date("H:i", $mooninfo->moonset);
//$result['moon']['moonrise1'] = $moonrise;
$result['moon']['moonrise'] = date("H:i", strtotime("{$moonrise} {$tzoffset} hours"));
//$result['moon']['moonset1'] = $moonset;
$result['moon']['moonset'] = date("H:i", strtotime("{$moonset} {$tzoffset} hours"));
$result['moon']['age'] = round($moon->get('age'), 1);
$result['moon']['stage'] = $moon->phase() < 0.5 ? 'waxing' : 'waning';
$result['moon']['phase'] = $moon->phase_name();
$result['moon']['distance'] = round($moon->get('distance'), 2);
$result['moon']['next_newmoon'] = gmdate('G:i:s, j M Y', $moon->get_phase('next_new_moon'));

// meta data
$result['meta']['lat'] 		= $lat;
$result['meta']['long'] 	= $long;
$result['meta']['tz'] 		= $tz;
//$result['meta']['tzoffset'] 	= $tzoffset;

// json response
if( isset( $_REQUEST['json'] ) && $_REQUEST['json'] == "1" ) {

	header("Content-type: application/json; charset=utf-8");
	http_response_code( 200 );
	echo json_encode( $result );
	exit;

} else { 
	// response plain html
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <title>myFlat</title>
<!--  <meta http-equiv="Refresh" content="300; url=./" /> -->
</head>
<body>

<div>
  <pre style="font-size:200%;">
<?php 
	foreach( $result as $id => $element ) {
		$oldkey = "";
		foreach( $element as $key => $value ) {
			if( strlen( $key ) < 5 ) $delimiter = "\t\t\t\t";
			else if( strlen( $key ) < 8 ) $delimiter = "\t\t\t";
			else if( strlen( $key ) < 16 ) $delimiter = "\t\t\t";
			else if( strlen( $key ) < 21 ) $delimiter = "\t\t";
			else if( strlen( $key ) < 26 ) $delimiter = "\t";
			else $delimiter = "\t";
			if( $id != $oldkey ) echo $id . "\n";
			$oldkey = $id;
			echo "  " . $key . ":" . $delimiter . $value .  "\n";
		}
	}
	if( isset( $_REQUEST['help'] ) && $_REQUEST['help'] == 1 ) {
		echo "\n";
		echo "help\n";
		//echo "Parameters - Function\n";
		echo "  lat - Latitude\n";
		echo "  long - Longitude\n";
		echo "  tz - Timezone\n";
	}
?>
  </pre>
</div>

</body>
</html>
<?php } ?>
